"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnnotationCRUDS = void 0;
var _use_update_annotation = require("./use_update_annotation");
var _use_create_annotation = require("./use_create_annotation");
var _use_delete_annotation = require("./use_delete_annotation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAnnotationCRUDS = () => {
  const {
    mutateAsync: createAnnotation,
    isLoading: isSaving
  } = (0, _use_create_annotation.useCreateAnnotation)();
  const {
    mutateAsync: updateAnnotation,
    isLoading: isUpdating
  } = (0, _use_update_annotation.useUpdateAnnotation)();
  const {
    mutateAsync: deleteAnnotation,
    isLoading: isDeleting
  } = (0, _use_delete_annotation.useDeleteAnnotation)();
  return {
    updateAnnotation,
    createAnnotation,
    deleteAnnotation,
    isSaving,
    isUpdating,
    isDeleting,
    isLoading: isSaving || isUpdating || isDeleting
  };
};
exports.useAnnotationCRUDS = useAnnotationCRUDS;