"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FirehosePanel = FirehosePanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _ebtTools = require("@kbn/ebt-tools");
var _pricing_features = require("../../../../common/pricing_features");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _empty_prompt = require("../shared/empty_prompt");
var _feedback_buttons = require("../shared/feedback_buttons");
var _create_stack_command_snippet = require("./create_stack_command_snippet");
var _create_stack_in_aws_console = require("./create_stack_in_aws_console");
var _types = require("./types");
var _use_firehose_flow = require("./use_firehose_flow");
var _visualize_data = require("./visualize_data");
var _use_window_blur_data_monitoring_trigger = require("../shared/use_window_blur_data_monitoring_trigger");
var _existing_data_callout = require("./existing_data_callout");
var _use_populated_aws_index_list = require("./use_populated_aws_index_list");
var _use_flow_breadcrumbs = require("../../shared/use_flow_breadcrumbs");
var _use_pricing_feature = require("../shared/use_pricing_feature");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/firehose/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OPTIONS = [{
  id: _types.CreateStackOption.AWS_CONSOLE_UI,
  label: _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.createStackAWSConsoleOptionLabel', {
    defaultMessage: 'Via AWS Console'
  })
}, {
  id: _types.CreateStackOption.AWS_CLI,
  label: _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.createStackAWSCLIOptionLabel', {
    defaultMessage: 'Via AWS CLI'
  })
}];
function FirehosePanel() {
  (0, _use_flow_breadcrumbs.useFlowBreadcrumb)({
    text: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.breadcrumbs.firehose', {
      defaultMessage: 'AWS Firehose'
    })
  });
  const [selectedOptionId, setSelectedOptionId] = (0, _react.useState)(_types.CreateStackOption.AWS_CONSOLE_UI);
  const {
    services: {
      context: {
        cloudServiceProvider
      }
    }
  } = (0, _public.useKibana)();
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_firehose_flow.useFirehoseFlow)();
  const {
    data: populatedAWSIndexList
  } = (0, _use_populated_aws_index_list.usePopulatedAWSIndexList)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  (0, _react.useEffect)(() => {
    if (data) {
      onPageReady({
        meta: {
          description: `[ttfmp_onboarding] Request to create the onboarding flow succeeded and the flow's UI has rendered`
        }
      });
    }
  }, [data, onPageReady]);
  const hasExistingData = Array.isArray(populatedAWSIndexList) && populatedAWSIndexList.length > 0;
  const telemetryEventContext = (0, _react.useMemo)(() => ({
    firehose: {
      cloudServiceProvider,
      selectedCreateStackOption: selectedOptionId
    }
  }), [cloudServiceProvider, selectedOptionId]);
  const isMonitoringData = (0, _use_window_blur_data_monitoring_trigger.useWindowBlurDataMonitoringTrigger)({
    isActive: status === _use_fetcher.FETCH_STATUS.SUCCESS,
    onboardingFlowType: 'firehose',
    onboardingId: data === null || data === void 0 ? void 0 : data.onboardingId,
    telemetryEventContext
  }) || hasExistingData;
  const onOptionChange = (0, _react.useCallback)(id => {
    setSelectedOptionId(id);
  }, []);
  if (error !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      onboardingFlowType: "firehose",
      error: error,
      telemetryEventContext: {
        firehose: {
          cloudServiceProvider
        }
      },
      onRetryClick: refetch,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 7
      }
    });
  }
  const steps = [{
    title: _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.prerequisitesTitle', {
      defaultMessage: 'Prerequisites'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability_onboarding.firehosePanel.prerequisitesDescription",
      defaultMessage: "You must have an active AWS account and the necessary permissions to create delivery streams.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability_onboarding.firehosePanel.prerequisitesDocumentation",
      defaultMessage: "{documentationLink} for more info.",
      values: {
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "observabilityOnboardingFirehosePanelCheckTheDocumentationLink",
          href: "https://www.elastic.co/docs/current/integrations/awsfirehose",
          external: true,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.documentationLinkLabel', {
          defaultMessage: 'Check the documentation'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    }))))
  }, {
    title: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.createDeliveryStreamTitle', {
      defaultMessage: 'Create a Firehose delivery stream to ingest CloudWatch logs and metrics'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.firehosePanel.createDeliveryStreamTitle', {
      defaultMessage: 'Create a Firehose delivery stream to ingest CloudWatch logs'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, status !== _use_fetcher.FETCH_STATUS.SUCCESS && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 5,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "170px",
      height: "40px",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 15
      }
    })), status === _use_fetcher.FETCH_STATUS.SUCCESS && data !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      legend: _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.createStackOptionsLegend', {
        defaultMessage: 'Select a preferred option to create a CloudFormation stack'
      }),
      type: "single",
      buttonSize: "m",
      idSelected: selectedOptionId,
      onChange: onOptionChange,
      options: OPTIONS,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 15
      }
    }), selectedOptionId === _types.CreateStackOption.AWS_CONSOLE_UI && /*#__PURE__*/_react.default.createElement(_create_stack_in_aws_console.CreateStackInAWSConsole, {
      templateUrl: data.templateUrl,
      encodedApiKey: data.apiKeyEncoded,
      elasticsearchUrl: data.elasticsearchUrl,
      isPrimaryAction: !isMonitoringData,
      metricsEnabled: metricsOnboardingEnabled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    }), selectedOptionId === _types.CreateStackOption.AWS_CLI && /*#__PURE__*/_react.default.createElement(_create_stack_command_snippet.CreateStackCommandSnippet, {
      templateUrl: data.templateUrl,
      encodedApiKey: data.apiKeyEncoded,
      elasticsearchUrl: data.elasticsearchUrl,
      isCopyPrimaryAction: !isMonitoringData,
      metricsEnabled: metricsOnboardingEnabled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 17
      }
    })))
  }, {
    title: 'Visualize your data',
    status: isMonitoringData ? 'current' : 'incomplete',
    children: isMonitoringData && data !== undefined && /*#__PURE__*/_react.default.createElement(_visualize_data.VisualizeData, {
      selectedCreateStackOption: selectedOptionId,
      onboardingId: data.onboardingId,
      hasExistingData: hasExistingData,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 5
    }
  }, hasExistingData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_existing_data_callout.ExistingDataCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
    flow: "firehose",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }));
}