"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collapseInternalToolCalls = collapseInternalToolCalls;
exports.convertMessagesForInference = convertMessagesForInference;
var _inferenceCommon = require("@kbn/inference-common");
var _common = require("@kbn/inference-plugin/common");
var _lodash = require("lodash");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function safeJsonParse(jsonString, logger) {
  try {
    var _jsonString$trim;
    return JSON.parse((_jsonString$trim = jsonString === null || jsonString === void 0 ? void 0 : jsonString.trim()) !== null && _jsonString$trim !== void 0 ? _jsonString$trim : '{}');
  } catch (error) {
    // if the LLM returns invalid JSON, it is likley because it is hallucinating
    // the function. We don't want to propogate the error about invalid JSON here.
    // Any errors related to the function call will be caught when the function and
    // it's arguments are validated
    return {};
  }
}
function collapseInternalToolCalls(messages, logger) {
  const collapsed = [];
  for (let i = 0; i < messages.length; i++) {
    const message = messages[i];
    if (message.message.role === _.MessageRole.User && message.message.name === 'query') {
      const messagesToCollapse = (0, _lodash.takeWhile)(messages.slice(i + 1), msg => {
        var _msg$message$function;
        const name = msg.message.name || ((_msg$message$function = msg.message.function_call) === null || _msg$message$function === void 0 ? void 0 : _msg$message$function.name);
        return name && ['query', 'visualize_query', 'execute_query'].includes(name);
      });
      if (messagesToCollapse.length) {
        const content = JSON.parse(message.message.content);
        collapsed.push({
          ...message,
          message: {
            ...message.message,
            content: JSON.stringify({
              ...content,
              steps: convertMessagesForInference(messagesToCollapse, logger)
            })
          }
        });
        i += messagesToCollapse.length;
        continue;
      }
    }
    collapsed.push(message);
  }
  return collapsed;
}
function convertMessagesForInference(messages, logger) {
  const inferenceMessages = [];
  const collapsedMessages = collapseInternalToolCalls(messages, logger);
  collapsedMessages.forEach((message, idx) => {
    if (message.message.role === _.MessageRole.Assistant) {
      var _message$message$cont, _message$message$func;
      inferenceMessages.push({
        role: _inferenceCommon.MessageRole.Assistant,
        content: (_message$message$cont = message.message.content) !== null && _message$message$cont !== void 0 ? _message$message$cont : null,
        ...((_message$message$func = message.message.function_call) !== null && _message$message$func !== void 0 && _message$message$func.name ? {
          toolCalls: [{
            function: {
              name: message.message.function_call.name,
              arguments: safeJsonParse(message.message.function_call.arguments, logger)
            },
            toolCallId: (0, _common.generateFakeToolCallId)()
          }]
        } : {})
      });
      return;
    }
    const isUserMessage = message.message.role === _.MessageRole.User;
    const isUserMessageWithToolCall = isUserMessage && !!message.message.name;
    if (isUserMessageWithToolCall) {
      var _message$message$cont2;
      const toolCallRequest = inferenceMessages.findLast(msg => {
        var _msg$toolCalls, _msg$toolCalls$;
        return msg.role === _inferenceCommon.MessageRole.Assistant && ((_msg$toolCalls = msg.toolCalls) === null || _msg$toolCalls === void 0 ? void 0 : (_msg$toolCalls$ = _msg$toolCalls[0]) === null || _msg$toolCalls$ === void 0 ? void 0 : _msg$toolCalls$.function.name) === message.message.name;
      });
      if (!toolCallRequest) {
        throw new Error(`Could not find tool call request for ${message.message.name}`);
      }
      inferenceMessages.push({
        name: message.message.name,
        role: _inferenceCommon.MessageRole.Tool,
        response: JSON.parse((_message$message$cont2 = message.message.content) !== null && _message$message$cont2 !== void 0 ? _message$message$cont2 : '{}'),
        toolCallId: toolCallRequest.toolCalls[0].toolCallId
      });
      return;
    }
    if (isUserMessage) {
      var _message$message$cont3;
      inferenceMessages.push({
        role: _inferenceCommon.MessageRole.User,
        content: (_message$message$cont3 = message.message.content) !== null && _message$message$cont3 !== void 0 ? _message$message$cont3 : ''
      });
      return;
    }
    throw new Error(`Unsupported message type: ${message.message.role}`);
  });
  return inferenceMessages;
}