"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantAppPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _aiAssistant = require("@kbn/ai-assistant");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _rule_connector = require("./rule_connector");
var _lazy_nav_control = require("./components/nav_control/lazy_nav_control");
var _shared_providers = require("./utils/shared_providers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_ai_assistant_app/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class ObservabilityAIAssistantAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "appService", void 0);
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    this.logger = context.logger.get();
    this.isServerless = context.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(coreSetup, _) {
    coreSetup.application.register({
      id: _deeplinksObservability.AI_ASSISTANT_APP_ID,
      title: _i18n.i18n.translate('xpack.observabilityAiAssistant.appTitle', {
        defaultMessage: 'Observability AI Assistant'
      }),
      euiIconType: 'logoObservability',
      appRoute: '/app/observabilityAIAssistant',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      visibleIn: [],
      deepLinks: [{
        id: 'conversations',
        title: _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationsDeepLinkTitle', {
          defaultMessage: 'Conversations'
        }),
        path: '/conversations/new'
      }],
      mount: async appMountParameters => {
        // Load application bundle and Get start services
        const [{
          Application
        }, [coreStart, pluginsStart]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application'))), coreSetup.getStartServices()]);
        _reactDom.default.render(/*#__PURE__*/_react.default.createElement(Application, (0, _extends2.default)({}, appMountParameters, {
          service: this.appService,
          coreStart: coreStart,
          pluginsStart: pluginsStart,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 11
          }
        })), appMountParameters.element);
        return () => {
          _reactDom.default.unmountComponentAtNode(appMountParameters.element);
        };
      }
    });
    return {};
  }
  start(coreStart, pluginsStart) {
    const appService = this.appService = (0, _aiAssistant.createAppService)({
      pluginsStart
    });
    const isEnabled = appService.isEnabled();
    if (isEnabled) {
      coreStart.chrome.navControls.registerRight({
        mount: element => {
          _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_lazy_nav_control.NavControlInitiator, {
            appService: appService,
            coreStart: coreStart,
            pluginsStart: pluginsStart,
            isServerless: this.isServerless,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 118,
              columnNumber: 13
            }
          }), element, () => {});
          return () => {
            _reactDom.default.unmountComponentAtNode(element);
          };
        },
        // right before the user profile
        order: 1001
      });
    }
    const service = pluginsStart.observabilityAIAssistant.service;
    service.register(async ({
      registerRenderFunction
    }) => {
      const {
        registerFunctions
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./functions')));
      await registerFunctions({
        pluginsStart,
        registerRenderFunction
      });
    });
    const withProviders = Component => /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_shared_providers.SharedProviders, {
      coreStart: coreStart,
      pluginsStart: pluginsStart,
      service: service,
      theme$: coreStart.theme.theme$,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
      ref: ref,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    }))));
    const LazilyLoadedRootCauseAnalysisContainer = (0, _sharedUxUtility.withSuspense)(withProviders(/*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/rca/rca_container'))).then(m => ({
      default: m.RootCauseAnalysisContainer
    })))));
    pluginsStart.triggersActionsUi.actionTypeRegistry.register((0, _rule_connector.getObsAIAssistantConnectorType)(service));
    return {
      RootCauseAnalysisContainer: LazilyLoadedRootCauseAnalysisContainer
    };
  }
}
exports.ObservabilityAIAssistantAppPlugin = ObservabilityAIAssistantAppPlugin;