"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsContent = exports.Logs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reason = require("./reason");
var _formatting = require("../../../common/formatting");
var _legacy_shims = require("../../legacy_shims");
var _external_config_context = require("../../application/contexts/external_config_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/logs/logs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getFormattedDateTimeLocal = timestamp => {
  var _Legacy$shims$uiSetti;
  const timezone = (_Legacy$shims$uiSetti = _legacy_shims.Legacy.shims.uiSettings) === null || _Legacy$shims$uiSetti === void 0 ? void 0 : _Legacy$shims$uiSetti.get('dateFormat:tz');
  return (0, _formatting.formatDateTimeLocal)(timestamp, timezone);
};
const columnTimestampTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.timestampTitle', {
  defaultMessage: 'Timestamp'
});
const columnLevelTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.levelTitle', {
  defaultMessage: 'Level'
});
const columnTypeTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.typeTitle', {
  defaultMessage: 'Type'
});
const columnMessageTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.messageTitle', {
  defaultMessage: 'Message'
});
const columnComponentTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.componentTitle', {
  defaultMessage: 'Component'
});
const columnNodeTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.nodeTitle', {
  defaultMessage: 'Node'
});
const columns = [{
  field: 'timestamp',
  name: columnTimestampTitle,
  width: '12%',
  render: timestamp => getFormattedDateTimeLocal(timestamp)
}, {
  field: 'level',
  name: columnLevelTitle,
  width: '5%'
}, {
  field: 'type',
  name: columnTypeTitle,
  width: '10%',
  render: type => (0, _lodash.upperFirst)(type)
}, {
  field: 'message',
  name: columnMessageTitle,
  width: '55%'
}, {
  field: 'component',
  name: columnComponentTitle,
  width: '18%'
}];
const clusterColumns = [{
  field: 'timestamp',
  name: columnTimestampTitle,
  width: '12%',
  render: timestamp => getFormattedDateTimeLocal(timestamp)
}, {
  field: 'level',
  name: columnLevelTitle,
  width: '5%'
}, {
  field: 'type',
  name: columnTypeTitle,
  width: '10%',
  render: type => (0, _lodash.upperFirst)(type)
}, {
  field: 'message',
  name: columnMessageTitle,
  width: '45%'
}, {
  field: 'component',
  name: columnComponentTitle,
  width: '15%'
}, {
  field: 'node',
  name: columnNodeTitle,
  width: '13%'
}];
function getDiscoverLink(clusterUuid, nodeId, indexUuid, sharePlugin, logsIndices) {
  const params = [];
  if (clusterUuid) {
    params.push(`elasticsearch.cluster.uuid:${clusterUuid}`);
  }
  if (nodeId) {
    params.push(`elasticsearch.node.id:${nodeId}`);
  }
  if (indexUuid) {
    params.push(`elasticsearch.index.name:${indexUuid}`);
  }
  const filter = params.join(' and ');
  const discoverLocator = sharePlugin === null || sharePlugin === void 0 ? void 0 : sharePlugin.url.locators.get('DISCOVER_APP_LOCATOR');
  const base = discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.getRedirectUrl({
    dataViewSpec: {
      id: logsIndices,
      title: logsIndices
    },
    query: {
      language: 'kuery',
      query: filter
    }
  });
  return base;
}
const Logs = props => {
  const {
    services: {
      share
    }
  } = (0, _public.useKibana)();
  const externalConfig = (0, _react.useContext)(_external_config_context.ExternalConfigContext);
  return /*#__PURE__*/_react.default.createElement(LogsContent, (0, _extends2.default)({
    sharePlugin: share,
    logsIndices: externalConfig.logsIndices
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 10
    }
  }));
};
exports.Logs = Logs;
class LogsContent extends _react.PureComponent {
  renderLogs() {
    const {
      logs: {
        enabled,
        logs
      },
      nodeId,
      indexUuid
    } = this.props;
    if (!enabled) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: logs || [],
      columns: nodeId || indexUuid ? columns : clusterColumns,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 7
      }
    });
  }
  renderNoLogs() {
    const {
      logs: {
        enabled,
        reason
      }
    } = this.props;
    if (enabled) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_reason.Reason, {
      reason: reason,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 12
      }
    });
  }
  renderCallout() {
    const {
      capabilities: uiCapabilities,
      kibanaServices
    } = _legacy_shims.Legacy.shims;
    const show = uiCapabilities.discover_v2 && uiCapabilities.discover_v2.show;
    const {
      logs: {
        enabled
      },
      nodeId,
      clusterUuid,
      indexUuid,
      sharePlugin,
      logsIndices
    } = this.props;
    if (!enabled || !show) {
      return null;
    }
    const discoverLink = getDiscoverLink(clusterUuid, nodeId, indexUuid, sharePlugin, logsIndices);
    return discoverLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      title: _i18n.i18n.translate('xpack.monitoring.logs.listing.calloutTitle', {
        defaultMessage: 'Want to see more log entries?'
      }),
      iconType: "logsApp",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: kibanaServices,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.listing.linkText",
      defaultMessage: "Visit {link} to dive deeper.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: discoverLink,
          "data-test-subj": "monitoringLogsLink",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 242,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.monitoring.logs.listing.calloutLinkText', {
          defaultMessage: 'Discover'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 11
      }
    }))) : null;
  }
  render() {
    const {
      nodeId,
      indexUuid,
      logs: {
        limit
      }
    } = this.props;
    let description;
    if (nodeId) {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.nodePageDescription', {
        defaultMessage: 'Showing the most recent log entries for this node, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    } else if (indexUuid) {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.indexPageDescription', {
        defaultMessage: 'Showing the most recent log entries for this index, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    } else {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.clusterPageDescription', {
        defaultMessage: 'Showing the most recent log entries for this cluster, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "monitoringLogs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.monitoring.logs.listing.pageTitle', {
      defaultMessage: 'Recent Log Entries'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 11
      }
    }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 9
      }
    }), this.renderLogs(), this.renderNoLogs(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 9
      }
    }), this.renderCallout());
  }
}
exports.LogsContent = LogsContent;