"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchStatusIcon = ElasticsearchStatusIcon;
var _react = _interopRequireDefault(require("react"));
var _status_icon = require("../status_icon");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/status_icon.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ElasticsearchStatusIcon({
  status
}) {
  const type = (() => {
    const statusKey = status.toUpperCase();
    return _status_icon.STATUS_ICON_TYPES[statusKey] || _status_icon.STATUS_ICON_TYPES.GRAY;
  })();
  return /*#__PURE__*/_react.default.createElement(_status_icon.StatusIcon, {
    type: type,
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.healthStatusLabel', {
      defaultMessage: 'Health: {status}',
      values: {
        status
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  });
}