"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterListing = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _listing = require("../../../components/cluster/listing");
var _enable_alerts_modal = require("../../../alerts/enable_alerts_modal");
var _global_state_context = require("../../contexts/global_state_context");
var _external_config_context = require("../../contexts/external_config_context");
var _use_table = require("../../hooks/use_table");
var _page_template = require("../page_template");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _fetch_clusters = require("../../../lib/fetch_clusters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/home/cluster_listing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const pageTitle = _i18n.i18n.translate('xpack.monitoring.cluster.listing.pageTitle', {
  defaultMessage: 'Cluster listing'
});
const tabTitle = _i18n.i18n.translate('xpack.monitoring.cluster.listing.tabTitle', {
  defaultMessage: 'Clusters'
});
const getAlerts = clusters => {
  return clusters.reduce((alerts, cluster) => ({
    ...alerts,
    ...(cluster.alerts && cluster.alerts.list || {})
  }), {});
};
const ClusterListing = () => {
  var _services$data2;
  const globalState = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const externalConfig = (0, _react.useContext)(_external_config_context.ExternalConfigContext);
  const {
    services
  } = (0, _public.useKibana)();
  const [clusters, setClusters] = (0, _react.useState)([]);
  const {
    update: updateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  const fakeScope = {
    $evalAsync: fn => fn(),
    filterQuery: '' // replace with something
  };
  const {
    getPaginationTableProps
  } = (0, _use_table.useTable)('clusters');
  const {
    sorting,
    pagination,
    onTableChange
  } = getPaginationTableProps();
  (0, _react.useEffect)(() => {
    updateBreadcrumbs([{
      'data-test-subj': 'clusterListingBreadcrumb',
      text: tabTitle
    }]);
  }, [updateBreadcrumbs]);
  const tabs = [{
    id: 'clusters',
    label: tabTitle,
    testSubj: 'clusterListingTab',
    route: '/home'
  }];
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch) {
      const response = await (0, _fetch_clusters.fetchClusters)({
        fetch: services.http.fetch,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        },
        ccs: globalState.ccs,
        codePaths: ['all']
      });
      setClusters(response);
    }
  }, [globalState.ccs, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  if (globalState.save && clusters.length === 1) {
    globalState.cluster_uuid = clusters[0].cluster_uuid;
    globalState.save();
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    tabs: tabs,
    title: pageTitle,
    pageTitle: pageTitle,
    getPageData: getPageData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, clusters.length === 1 && /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: '/overview'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 33
    }
  }), /*#__PURE__*/_react.default.createElement(_listing.Listing, {
    clusters: clusters,
    angular: {
      scope: fakeScope,
      globalState,
      storage: {
        get: key => window.localStorage.getItem(key),
        set: (key, value) => window.localStorage.setItem(key, value)
      },
      showLicenseExpiration: externalConfig.showLicenseExpiration
    },
    sorting: sorting,
    pagination: pagination,
    onTableChange: onTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_enable_alerts_modal.EnableAlertsModal, {
    alerts: getAlerts(clusters),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }));
};
exports.ClusterListing = ClusterListing;