"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowAlertBadge = shouldShowAlertBadge;
var _setup_mode = require("../../lib/setup_mode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function shouldShowAlertBadge(alerts, alertTypeIds, context) {
  if (!alerts) {
    return false;
  }
  const inSetupMode = (0, _setup_mode.isInSetupMode)(context);
  const alertExists = alertTypeIds.find(name => alerts[name] && alerts[name].find(rule => rule.states.length > 0));
  return inSetupMode || alertExists;
}