"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _kibana = require("../../../contexts/kibana");
var _components = require("./components");
var _locator = require("../../../../../common/constants/locator");
var _use_refresh = require("../../../routing/use_refresh");
var _use_ref_dimensions = require("./components/use_ref_dimensions");
var _use_fetch_analytics_map_data = require("./use_fetch_analytics_map_data");
var _use_create_url = require("../../../contexts/kibana/use_create_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/job_map/job_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getCytoscapeDivStyle = theme => ({
  background: `linear-gradient(
  90deg,
  ${theme.colors.backgroundBasePlain}
    calc(${theme.size.l} - calc(${theme.size.xs} / 2)),
  transparent 1%
)
center,
linear-gradient(
  ${theme.colors.backgroundBasePlain}
    calc(${theme.size.l} - calc(${theme.size.xs} / 2)),
  transparent 1%
)
center,
${theme.colors.lightShade}`,
  backgroundSize: `${theme.size.l} ${theme.size.l}`,
  marginTop: 0
});
const JobMap = ({
  defaultHeight,
  analyticsId,
  modelId,
  forceRefresh
}) => {
  // itemsDeleted will reset to false when Controls component calls updateElements to remove nodes deleted from map
  const [itemsDeleted, setItemsDeleted] = (0, _react.useState)(false);
  const [resetCyToggle, setResetCyToggle] = (0, _react.useState)(false);
  const {
    elements,
    error,
    fetchAndSetElementsWrapper,
    message,
    nodeDetails,
    setElements,
    setError
  } = (0, _use_fetch_analytics_map_data.useFetchAnalyticsMapData)();
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const refresh = (0, _use_refresh.useRefresh)();
  const redirectToAnalyticsManagementPage = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE, 'analytics');
  const updateElements = (nodeId, nodeLabel, destIndexNode) => {
    // If removing the root job just go back to the jobs list
    if (nodeLabel === analyticsId) {
      redirectToAnalyticsManagementPage();
    } else {
      // Remove job element
      const filteredElements = elements.filter(e => {
        // Filter out job node and related edges, including trained model node.
        let isNotDeletedNodeOrRelated = e.data.id !== nodeId && e.data.target !== nodeId && e.data.source !== nodeId;
        if (e.data.id !== undefined && e.data.type === _mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.TRAINED_MODEL) {
          var _nodeDetails$e$data$i, _nodeDetails$e$data$i2, _nodeDetails$e$data$i3;
          // remove training model node related to that job
          isNotDeletedNodeOrRelated = isNotDeletedNodeOrRelated && ((_nodeDetails$e$data$i = nodeDetails[e.data.id]) === null || _nodeDetails$e$data$i === void 0 ? void 0 : (_nodeDetails$e$data$i2 = _nodeDetails$e$data$i.metadata) === null || _nodeDetails$e$data$i2 === void 0 ? void 0 : (_nodeDetails$e$data$i3 = _nodeDetails$e$data$i2.analytics_config) === null || _nodeDetails$e$data$i3 === void 0 ? void 0 : _nodeDetails$e$data$i3.id) !== nodeLabel;
        }
        if (destIndexNode !== undefined) {
          // Filter out destination index node for that job
          return isNotDeletedNodeOrRelated && e.data.id !== destIndexNode && e.data.target !== destIndexNode && e.data.source !== destIndexNode;
        }
        return isNotDeletedNodeOrRelated;
      });
      setItemsDeleted(true);
      setElements(filteredElements);
    }
  };
  (0, _react.useEffect)(() => {
    fetchAndSetElementsWrapper({
      analyticsId,
      modelId
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [analyticsId, modelId]);
  (0, _react.useEffect)(() => {
    if (forceRefresh === true) {
      fetchAndSetElementsWrapper({
        analyticsId,
        modelId
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [forceRefresh]);
  (0, _react.useEffect)(() => {
    if (message !== undefined) {
      notifications.toasts.add(message);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [message]);
  (0, _react.useEffect)(function updateOnTimerRefresh() {
    if (!refresh) return;
    fetchAndSetElementsWrapper({
      analyticsId,
      modelId
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [refresh]);
  if (error !== undefined) {
    notifications.toasts.addDanger(_i18n.i18n.translate('xpack.ml.dataframe.analyticsMap.fetchDataErrorMessage', {
      defaultMessage: 'Unable to fetch some data. An error occurred: {error}',
      values: {
        error: JSON.stringify(error)
      }
    }));
    setError(undefined);
  }
  const {
    ref,
    width,
    height
  } = (0, _use_ref_dimensions.useRefDimensions)();
  const refreshCallback = () => fetchAndSetElementsWrapper({
    analyticsId,
    modelId
  });
  const hasMissingJobNode = (0, _react.useMemo)(() => elements.map(({
    data
  }) => data.type).includes(_mlDataFrameAnalyticsUtils.JOB_MAP_NODE_TYPES.ANALYTICS_JOB_MISSING), [elements]);
  const h = defaultHeight !== null && defaultHeight !== void 0 ? defaultHeight : height;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlPageDataFrameAnalyticsMap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.JobMapLegend, {
    hasMissingJobNode: hasMissingJobNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    "data-test-subj": "mlAnalyticsResetGraphButton"
    // trigger reset on value change
    ,
    onClick: () => setResetCyToggle(!resetCyToggle),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analyticsList.resetMapButtonLabel",
    defaultMessage: "Reset",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: h - parseInt(euiTheme.size.l, 10) - 20
    },
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.Cytoscape, {
    height: h - 20,
    elements: elements,
    width: width,
    style: getCytoscapeDivStyle(euiTheme),
    itemsDeleted: itemsDeleted,
    resetCy: resetCyToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.Controls, {
    details: nodeDetails,
    getNodeData: fetchAndSetElementsWrapper,
    modelId: modelId,
    updateElements: updateElements,
    refreshJobsCallback: refreshCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }))));
};
exports.JobMap = JobMap;