"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeAvailableWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _ml_nodes_check = require("../../ml_nodes_check");
var _ml_server_info = require("../../services/ml_server_info");
var _warning = require("./warning");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/node_available_warning/node_available_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NodeAvailableWarning = () => {
  if ((0, _ml_nodes_check.mlNodesAvailable)() === true || (0, _ml_nodes_check.permissionToViewMlNodeCount)() === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_warning.Warning, {
    isCloud: (0, _ml_server_info.isCloud)(),
    isCloudTrial: (0, _ml_server_info.isCloudTrial)(),
    deploymentId: (0, _ml_server_info.getCloudDeploymentId)(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  });
};
exports.NodeAvailableWarning = NodeAvailableWarning;