"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopMetricsTypeRT = exports.TermsWithMetrics = exports.PercentilesTypeRT = exports.PercentilesKeyedTypeRT = exports.NormalizedMetricValueRT = exports.MetricsetRT = exports.MetricsBucketRT = exports.MetricValueTypeRT = exports.MaxPeriodFilterExistsTypeRT = exports.HistogramRT = exports.HistogramBucketRT = exports.CompositeResponseRT = exports.BucketRT = exports.BasicMetricValueRT = exports.AggregationResponseRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NumberOrNullRT = rt.union([rt.number, rt.null]);
const BasicMetricValueRT = exports.BasicMetricValueRT = rt.type({
  value: NumberOrNullRT
});
const NormalizedMetricValueRT = exports.NormalizedMetricValueRT = rt.intersection([BasicMetricValueRT, rt.type({
  normalized_value: NumberOrNullRT
})]);
const PercentilesTypeRT = exports.PercentilesTypeRT = rt.type({
  values: rt.record(rt.string, NumberOrNullRT)
});
const PercentilesKeyedTypeRT = exports.PercentilesKeyedTypeRT = rt.type({
  values: rt.array(rt.type({
    key: rt.string,
    value: NumberOrNullRT
  }))
});
const TopMetricsTypeRT = exports.TopMetricsTypeRT = rt.type({
  top: rt.array(rt.type({
    sort: rt.union([rt.array(rt.number), rt.array(rt.string)]),
    metrics: rt.record(rt.string, rt.union([rt.number, rt.string, rt.null]))
  }))
});
const MaxPeriodFilterExistsTypeRT = exports.MaxPeriodFilterExistsTypeRT = rt.type({
  doc_count: rt.number,
  period: BasicMetricValueRT
});
const MetricValueTypeRT = exports.MetricValueTypeRT = rt.union([BasicMetricValueRT, NormalizedMetricValueRT, PercentilesTypeRT, PercentilesKeyedTypeRT, TopMetricsTypeRT, MaxPeriodFilterExistsTypeRT]);
const TermsWithMetrics = exports.TermsWithMetrics = rt.intersection([rt.type({
  buckets: rt.array(rt.record(rt.string, rt.union([rt.number, rt.string, MetricValueTypeRT])))
}), rt.partial({
  sum_other_doc_count: rt.number,
  doc_count_error_upper_bound: rt.number
})]);
const BucketRT = exports.BucketRT = rt.record(rt.string, rt.union([rt.number, rt.string, MetricValueTypeRT, TermsWithMetrics, rt.record(rt.string, rt.string), rt.type({
  doc_count: rt.number
})]));
const MetricsetRT = exports.MetricsetRT = rt.type({
  buckets: rt.array(rt.type({
    key: rt.string,
    doc_count: rt.number
  }))
});
const HistogramRT = exports.HistogramRT = rt.type({
  histogram: rt.type({
    buckets: rt.array(BucketRT)
  }),
  metricsets: MetricsetRT
});
const MetricsBucketRT = exports.MetricsBucketRT = rt.intersection([BucketRT, rt.type({
  metricsets: MetricsetRT
})]);
const HistogramBucketRT = exports.HistogramBucketRT = rt.intersection([rt.type({
  key: rt.record(rt.string, rt.string),
  doc_count: rt.number
}), HistogramRT]);
const AggregationResponseRT = exports.AggregationResponseRT = HistogramRT;
const CompositeResponseRT = exports.CompositeResponseRT = rt.type({
  groupings: rt.intersection([rt.type({
    buckets: rt.array(rt.union([HistogramBucketRT, MetricsBucketRT]))
  }), rt.partial({
    after_key: rt.record(rt.string, rt.string)
  })])
});