"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vectorLayerSchema = exports.rasterLayerSchema = exports.layersSchema = exports.layerGroupSchema = exports.heatmapLayerSchema = exports.attributionSchema = exports.EMSVectorTileLayerSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQueryServer = require("@kbn/es-query-server");
var _common = require("../../../../../common");
var _source_schemas = require("../source_schemas/source_schemas");
var _es_join_source_schemas = require("../source_schemas/es_join_source_schemas");
var _style_schemas = require("../style_schemas/style_schemas");
var _vector_style_schemas = require("../style_schemas/vector_style_schemas/vector_style_schemas");
var _es_agg_source_schemas = require("../source_schemas/es_agg_source_schemas");
var _es_source_schemas = require("../source_schemas/es_source_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const attributionSchema = exports.attributionSchema = _configSchema.schema.object({
  label: _configSchema.schema.string(),
  url: _configSchema.schema.uri()
});
const layerSchema = _configSchema.schema.object({
  alpha: _configSchema.schema.maybe(_configSchema.schema.number({
    defaultValue: 0.75,
    min: 0,
    max: 1,
    meta: {
      description: 'Layer opacity'
    }
  })),
  attribution: _configSchema.schema.maybe(attributionSchema),
  id: _configSchema.schema.string(),
  includeInFitToBounds: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Set to false to exclude layer in fit to bounds computation'
    }
  })),
  label: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Layer name displayed in UI'
    }
  })),
  maxZoom: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 0,
    max: 24,
    meta: {
      description: 'Layer visibility max zoom level. Layer displayed when map zoom level is less than or equal to maxZoom. When both maxZoom and minZoom are provided, layer is displayed when map zoom level is between maxZoom and minZoom.'
    }
  })),
  minZoom: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 0,
    max: 24,
    meta: {
      description: 'Layer visibility min zoom level. Layer displayed when map zoom level is greater than or equal to minZoom.  When both maxZoom and minZoom are provided, layer is displayed when map zoom level is between maxZoom and minZoom.'
    }
  })),
  parent: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Layers can be organized in a hierically for easy management in the UI. Use parent to specfify the id of LAYER_GROUP that contains this layer'
    }
  })),
  query: _configSchema.schema.maybe(_esQueryServer.querySchema),
  visible: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: true,
    meta: {
      description: `When set to false, layer will appear in legend as 'hidden' and no load data`
    }
  }))
});
const EMSVectorTileLayerSchema = exports.EMSVectorTileLayerSchema = layerSchema.extends({
  areLabelsOnTop: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Set to true to display labels on top of all layers regardless of layer ordering'
    }
  })),
  locale: _configSchema.schema.maybe(_configSchema.schema.string()),
  sourceDescriptor: _source_schemas.EMSTMSSourceSchema,
  style: _style_schemas.EMSVectorTileStyleSchema,
  type: _configSchema.schema.literal(_common.LAYER_TYPE.EMS_VECTOR_TILE)
});
const heatmapLayerSchema = exports.heatmapLayerSchema = layerSchema.extends({
  sourceDescriptor: _es_agg_source_schemas.ESGeoGridSourceSchema,
  style: _style_schemas.heatmapStyleSchema,
  type: _configSchema.schema.literal(_common.LAYER_TYPE.HEATMAP)
});
const layerGroupSchema = exports.layerGroupSchema = layerSchema.extends({
  label: _configSchema.schema.string(),
  type: _configSchema.schema.literal(_common.LAYER_TYPE.LAYER_GROUP),
  visible: _configSchema.schema.boolean()
});
const rasterLayerSchema = exports.rasterLayerSchema = layerSchema.extends({
  sourceDescriptor: _configSchema.schema.oneOf([_configSchema.schema.object({
    type: _configSchema.schema.string()
  }, {
    unknowns: 'allow'
  }), _source_schemas.kibanaTilemapSourceSchema, _source_schemas.WMSSourceSchema, _source_schemas.XYZTMSSourceSchema]),
  type: _configSchema.schema.literal(_common.LAYER_TYPE.RASTER_TILE)
});
const joinSchema = _configSchema.schema.object({
  leftField: _configSchema.schema.maybe(_configSchema.schema.string()),
  right: _es_join_source_schemas.joinSourceSchema
});
const vectorLayerSchema = exports.vectorLayerSchema = layerSchema.extends({
  disableTooltips: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: false,
    meta: {
      description: 'Set to true to disable tooltip for layer features'
    }
  })),
  joins: _configSchema.schema.maybe(_configSchema.schema.arrayOf(joinSchema)),
  sourceDescriptor: _configSchema.schema.oneOf([_configSchema.schema.object({
    type: _configSchema.schema.string()
  }, {
    unknowns: 'allow'
  }), _source_schemas.EMSFileSourceSchema, _source_schemas.TiledSingleLayerVectorSourceSchema, _es_agg_source_schemas.ESGeoGridSourceSchema, _es_agg_source_schemas.ESGeoLineSourceSchema, _es_agg_source_schemas.ESPewPewSourceSchema, _es_source_schemas.ESSearchSourceSchema, _es_source_schemas.ESQLSourceSchema]),
  style: _vector_style_schemas.vectorStyleSchema,
  type: _configSchema.schema.oneOf([_configSchema.schema.literal(_common.LAYER_TYPE.BLENDED_VECTOR), _configSchema.schema.literal(_common.LAYER_TYPE.GEOJSON_VECTOR), _configSchema.schema.literal(_common.LAYER_TYPE.MVT_VECTOR)])
});
const layersSchema = exports.layersSchema = _configSchema.schema.oneOf([EMSVectorTileLayerSchema, heatmapLayerSchema, layerGroupSchema, rasterLayerSchema, vectorLayerSchema, _configSchema.schema.object({}, {
  unknowns: 'allow'
})]);