"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StopInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/stop_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class StopInput extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onFocus", () => {
      if (!this.state.hasPrevFocus) {
        this.setState({
          hasPrevFocus: true
        });
        this._onSearchChange('');
      }
    });
    (0, _defineProperty2.default)(this, "_onChange", selectedOptions => {
      this.props.onChange(_lodash.default.get(selectedOptions, '[0].label', ''));
    });
    (0, _defineProperty2.default)(this, "_onCreateOption", newValue => {
      this.props.onChange(newValue);
    });
    (0, _defineProperty2.default)(this, "_onSearchChange", async searchValue => {
      this.setState({
        isLoadingSuggestions: true,
        searchValue
      }, () => {
        this._loadSuggestions(searchValue);
      });
    });
    (0, _defineProperty2.default)(this, "_loadSuggestions", _lodash.default.debounce(async searchValue => {
      let suggestions = [];
      try {
        suggestions = await this.props.getValueSuggestions(searchValue);
      } catch (error) {
        // ignore suggestions error
      }
      if (this._isMounted && searchValue === this.state.searchValue) {
        this.setState({
          isLoadingSuggestions: false,
          suggestions
        });
      }
    }, 300));
    (0, _defineProperty2.default)(this, "_onFieldTextChange", event => {
      this.setState({
        localFieldTextValue: event.target.value
      });
      // onChange can cause UI lag, ensure smooth input typing by debouncing onChange
      this._debouncedOnFieldTextChange();
    });
    (0, _defineProperty2.default)(this, "_debouncedOnFieldTextChange", _lodash.default.debounce(() => {
      this.props.onChange(this.state.localFieldTextValue);
    }, 500));
    this.state = {
      suggestions: [],
      isLoadingSuggestions: false,
      hasPrevFocus: false,
      fieldDataType: null,
      localFieldTextValue: props.value
    };
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadFieldDataType();
  }
  componentWillUnmount() {
    this._isMounted = false;
    this._loadSuggestions.cancel();
  }
  async _loadFieldDataType() {
    const fieldDataType = await this.props.field.getDataType();
    if (this._isMounted) {
      this.setState({
        fieldDataType
      });
    }
  }
  _renderSuggestionInput() {
    const suggestionOptions = this.state.suggestions.map(suggestion => {
      return {
        label: `${suggestion}`
      };
    });
    const selectedOptions = [];
    if (this.props.value) {
      let option = suggestionOptions.find(({
        label
      }) => {
        return label === this.props.value;
      });
      if (!option) {
        option = {
          label: this.props.value
        };
        suggestionOptions.unshift(option);
      }
      selectedOptions.push(option);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      options: suggestionOptions,
      selectedOptions: selectedOptions,
      singleSelection: _constants.SINGLE_SELECTION_AS_TEXT_PROPS,
      onChange: this._onChange,
      onSearchChange: this._onSearchChange,
      onCreateOption: this._onCreateOption,
      isClearable: false,
      isLoading: this.state.isLoadingSuggestions,
      onFocus: this._onFocus,
      "data-test-subj": this.props.dataTestSubj,
      compressed: true,
      "aria-label": _i18n.i18n.translate('xpack.maps.stopInput.valueComboBoxAriaLabel', {
        defaultMessage: 'Stop value'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    });
  }
  _renderTextInput() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.localFieldTextValue,
      onChange: this._onFieldTextChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 7
      }
    });
  }
  render() {
    if (!this.state.fieldDataType) {
      return null;
    }

    // autocomplete service can not provide suggestions for non string fields (and boolean) because it uses
    // term aggregation include parameter. Include paramerter uses a regular expressions that only supports string type
    return this.state.fieldDataType === 'string' || this.state.fieldDataType === 'boolean' ? this._renderSuggestionInput() : this._renderTextInput();
  }
}
exports.StopInput = StopInput;