"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.managementSidebarNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/management/public/components/management_sidebar_nav/management_sidebar_nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** @internal **/
const managementSidebarNav = ({
  selectedId,
  sections,
  history
}) => {
  const sectionsToNavItems = managementSections => {
    const sortedManagementSections = (0, _lodash.sortBy)(managementSections, 'order');
    return sortedManagementSections.reduce((acc, section) => {
      const apps = (0, _lodash.sortBy)(section.getAppsEnabled().filter(app => !app.hideFromSidebar), 'order');
      if (apps.length) {
        if (!section.hideFromSidebar) {
          acc.push({
            ...createNavItem(section, {
              items: appsToNavItems(apps)
            })
          });
        }
      }
      return acc;
    }, []);
  };
  const appsToNavItems = managementApps => managementApps.map(app => ({
    ...createNavItem(app, {
      ...(0, _public.reactRouterNavigate)(history, app.basePath)
    })
  }));
  const HeaderWrapper = ({
    text,
    tip
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, text), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tip,
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
  const createNavItem = (item, customParams = {}) => {
    const iconType = item.euiIconType || item.icon;
    return {
      id: item.id,
      name: item.tip ? /*#__PURE__*/_react.default.createElement(HeaderWrapper, {
        text: item.title,
        tip: item.tip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 24
        }
      }) : item.title,
      isSelected: item.id === selectedId,
      icon: iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: iconType,
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 24
        }
      }) : undefined,
      'data-test-subj': item.id,
      ...customParams
    };
  };
  return sectionsToNavItems(sections);
};
exports.managementSidebarNav = managementSidebarNav;