"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnWidthToCSS = columnWidthToCSS;
exports.isFieldColumnRenderConfiguration = isFieldColumnRenderConfiguration;
exports.isMessageColumnRenderConfiguration = isMessageColumnRenderConfiguration;
exports.isTimestampColumnRenderConfiguration = isTimestampColumnRenderConfiguration;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Interface for common configuration properties, regardless of the column type.
 */

function isTimestampColumnRenderConfiguration(column) {
  return 'timestampColumn' in column;
}
function isMessageColumnRenderConfiguration(column) {
  return 'messageColumn' in column;
}
function isFieldColumnRenderConfiguration(column) {
  return 'fieldColumn' in column;
}
function columnWidthToCSS(width) {
  return typeof width === 'number' ? `${width}px` : width;
}