"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistedLogViewReferenceRT = exports.logViewStatusRT = exports.logViewReferenceRT = exports.logViewRT = exports.logViewOriginRT = exports.logViewIndexStatusRT = exports.logViewFieldColumnConfigurationRT = exports.logViewColumnConfigurationRT = exports.logViewAttributesRT = exports.logSourcesKibanaAdvancedSettingRT = exports.logIndexReferenceRT = exports.logIndexNameReferenceRT = exports.logDataViewReferenceRT = exports.inlineLogViewReferenceRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logViewOriginRT = exports.logViewOriginRT = rt.keyof({
  stored: null,
  internal: null,
  inline: null,
  'infra-source-stored': null,
  'infra-source-internal': null,
  'infra-source-fallback': null
});
// Kibana data views
const logDataViewReferenceRT = exports.logDataViewReferenceRT = rt.type({
  type: rt.literal('data_view'),
  dataViewId: rt.string
});
// Index name
const logIndexNameReferenceRT = exports.logIndexNameReferenceRT = rt.type({
  type: rt.literal('index_name'),
  indexName: rt.string
});
// Kibana advanced setting
const logSourcesKibanaAdvancedSettingRT = exports.logSourcesKibanaAdvancedSettingRT = rt.type({
  type: rt.literal('kibana_advanced_setting')
});
const logIndexReferenceRT = exports.logIndexReferenceRT = rt.union([logDataViewReferenceRT, logIndexNameReferenceRT, logSourcesKibanaAdvancedSettingRT]);
const logViewCommonColumnConfigurationRT = rt.strict({
  id: rt.string
});
const logViewTimestampColumnConfigurationRT = rt.strict({
  timestampColumn: logViewCommonColumnConfigurationRT
});
const logViewMessageColumnConfigurationRT = rt.strict({
  messageColumn: logViewCommonColumnConfigurationRT
});
const logViewFieldColumnConfigurationRT = exports.logViewFieldColumnConfigurationRT = rt.strict({
  fieldColumn: rt.intersection([logViewCommonColumnConfigurationRT, rt.strict({
    field: rt.string
  })])
});
const logViewColumnConfigurationRT = exports.logViewColumnConfigurationRT = rt.union([logViewTimestampColumnConfigurationRT, logViewMessageColumnConfigurationRT, logViewFieldColumnConfigurationRT]);
const logViewAttributesRT = exports.logViewAttributesRT = rt.strict({
  name: rt.string,
  description: rt.string,
  logIndices: logIndexReferenceRT,
  logColumns: rt.array(logViewColumnConfigurationRT)
});
const logViewRT = exports.logViewRT = rt.exact(rt.intersection([rt.type({
  id: rt.string,
  origin: logViewOriginRT,
  attributes: logViewAttributesRT
}), rt.partial({
  updatedAt: rt.number,
  version: rt.string
})]));
const logViewIndexStatusRT = exports.logViewIndexStatusRT = rt.keyof({
  available: null,
  empty: null,
  missing: null,
  unknown: null
});
const logViewStatusRT = exports.logViewStatusRT = rt.strict({
  index: logViewIndexStatusRT
});
const persistedLogViewReferenceRT = exports.persistedLogViewReferenceRT = rt.type({
  logViewId: rt.string,
  type: rt.literal('log-view-reference')
});
const inlineLogViewReferenceRT = exports.inlineLogViewReferenceRT = rt.type({
  type: rt.literal('log-view-inline'),
  id: rt.string,
  attributes: logViewAttributesRT
});
const logViewReferenceRT = exports.logViewReferenceRT = rt.union([persistedLogViewReferenceRT, inlineLogViewReferenceRT]);