"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeatmapHorizontalAxisSettings = HeatmapHorizontalAxisSettings;
exports.HeatmapTitlesAndTextSettings = HeatmapTitlesAndTextSettings;
exports.HeatmapVerticalAxisSettings = HeatmapVerticalAxisSettings;
var _react = _interopRequireDefault(require("react"));
var _shared_components = require("../../../shared_components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/heatmap/toolbar_component/style_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function HeatmapTitlesAndTextSettings({
  state,
  setState
}) {
  return /*#__PURE__*/_react.default.createElement(_shared_components.ValueLabelsSettings, {
    valueLabels: state !== null && state !== void 0 && state.gridConfig.isCellLabelVisible ? 'show' : 'hide',
    onValueLabelChange: newMode => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isCellLabelVisible: newMode === 'show'
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
}
function HeatmapVerticalAxisSettings({
  state,
  setState
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarTitleSettings, {
    settingId: "yLeft",
    title: state === null || state === void 0 ? void 0 : state.gridConfig.yTitle,
    updateTitleState: ({
      title,
      visible
    }) => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          yTitle: title,
          isYAxisTitleVisible: visible
        }
      });
    },
    isTitleVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isYAxisTitleVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_components.AxisTicksSettings, {
    axis: "yLeft",
    updateTicksVisibilityState: visible => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isYAxisLabelVisible: visible
        }
      });
    },
    isAxisLabelVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isYAxisLabelVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
}
function HeatmapHorizontalAxisSettings({
  state,
  setState
}) {
  const isXAxisLabelVisible = state === null || state === void 0 ? void 0 : state.gridConfig.isXAxisLabelVisible;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarTitleSettings, {
    settingId: "x",
    title: state === null || state === void 0 ? void 0 : state.gridConfig.xTitle,
    updateTitleState: ({
      title,
      visible
    }) => setState({
      ...state,
      gridConfig: {
        ...state.gridConfig,
        xTitle: title,
        isXAxisTitleVisible: visible
      }
    }),
    isTitleVisible: state === null || state === void 0 ? void 0 : state.gridConfig.isXAxisTitleVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_components.AxisTicksSettings, {
    axis: "x",
    updateTicksVisibilityState: visible => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          isXAxisLabelVisible: visible
        }
      });
    },
    isAxisLabelVisible: isXAxisLabelVisible,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), isXAxisLabelVisible && /*#__PURE__*/_react.default.createElement(_shared_components.AxisLabelOrientationSelector, {
    axis: "x",
    selectedLabelOrientation: _shared_components.allowedOrientations.includes(state.gridConfig.xAxisLabelRotation) ? state.gridConfig.xAxisLabelRotation : 0 // Default to 0 if the value is not valid
    ,
    setLabelOrientation: orientation => {
      setState({
        ...state,
        gridConfig: {
          ...state.gridConfig,
          xAxisLabelRotation: orientation
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }));
}