"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAccessorsFromState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAccessorsFromState = state => {
  const {
    minAccessor,
    maxAccessor,
    goalAccessor,
    metricAccessor
  } = state !== null && state !== void 0 ? state : {};
  if (!metricAccessor && !maxAccessor && !goalAccessor && !metricAccessor) {
    return;
  }
  return {
    min: minAccessor,
    max: maxAccessor,
    goal: goalAccessor,
    metric: metricAccessor
  };
};
exports.getAccessorsFromState = getAccessorsFromState;