"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "GaugeFlyoutToolbar", {
  enumerable: true,
  get: function () {
    return _flyout_toolbar.GaugeFlyoutToolbar;
  }
});
exports.GaugeToolbar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _shared_components = require("../../../shared_components");
var _appearance_settings = require("./appearance_settings");
var _titles_and_text_settings = require("./titles_and_text_settings");
var _flyout_toolbar = require("./flyout_toolbar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/gauge/toolbar_component/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GaugeToolbar = exports.GaugeToolbar = /*#__PURE__*/(0, _react.memo)(props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AppearancePopover, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(TitlesAndTextPopover, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }))));
});
const AppearancePopover = props => {
  const {
    state,
    setState
  } = props;
  return /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.gauge.appearanceLabel', {
      defaultMessage: 'Appearance'
    }),
    type: "visualOptions",
    buttonDataTestSubj: "lnsVisualOptionsButton",
    panelStyle: {
      width: '500px'
    },
    "data-test-subj": "lnsVisualOptionsPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_appearance_settings.AppearanceSettings, {
    state: state,
    setState: setState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }));
};
const TitlesAndTextPopover = props => {
  const {
    state,
    setState
  } = props;
  const [subtitleMode, setSubtitleMode] = (0, _react.useState)(() => state.labelMinor ? 'custom' : 'none');
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    onChange: setState,
    value: state
  });
  return /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    handleClose: () => {
      setSubtitleMode(inputValue.labelMinor ? 'custom' : 'none');
    },
    title: _i18n.i18n.translate('xpack.lens.gauge.appearanceLabel', {
      defaultMessage: 'Titles and text'
    }),
    type: "titlesAndText",
    buttonDataTestSubj: "lnsTextOptionsButton",
    panelStyle: {
      width: '500px'
    },
    "data-test-subj": "lnsTextOptionsPopover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_titles_and_text_settings.TitlesAndTextSettings, (0, _extends2.default)({}, props, {
    inputValue: inputValue,
    handleInputChange: handleInputChange,
    subtitleMode: subtitleMode,
    setSubtitleMode: setSubtitleMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  })));
};