"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFormulaPublicApi = void 0;
var _loader = require("../../../../../data_views_service/loader");
var _parse = require("./parse");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @public **/

/** @public **/
const createFormulaPublicApi = () => {
  const cache = new WeakMap();
  const getCachedLensIndexPattern = dataView => {
    const cachedIndexPattern = cache.get(dataView);
    if (cachedIndexPattern) {
      return cachedIndexPattern;
    }
    const indexPattern = (0, _loader.convertDataViewIntoLensIndexPattern)(dataView);
    cache.set(dataView, indexPattern);
    return indexPattern;
  };
  return {
    insertOrReplaceFormulaColumn: (id, {
      formula,
      label,
      format,
      filter,
      reducedTimeRange,
      timeScale
    }, layer, dataView, dateRange) => {
      const indexPattern = getCachedLensIndexPattern(dataView);
      return (0, _parse.insertOrReplaceFormulaColumn)(id, {
        label: label !== null && label !== void 0 ? label : formula,
        customLabel: Boolean(label),
        operationType: 'formula',
        dataType: 'number',
        references: [],
        isBucketed: false,
        filter,
        reducedTimeRange,
        timeScale,
        params: {
          formula,
          format
        }
      }, {
        ...layer,
        indexPatternId: indexPattern.id
      }, {
        indexPattern,
        dateRange
      }).layer;
    }
  };
};
exports.createFormulaPublicApi = createFormulaPublicApi;