"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMessageContentAndRole = exports.ActionsClientSimpleChatModel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _chat_models = require("@langchain/core/language_models/chat_models");
var _messages = require("@langchain/core/messages");
var _uuid = require("uuid");
var _fp = require("lodash/fp");
var _outputs = require("@langchain/core/outputs");
var _gemini = require("../utils/gemini");
var _bedrock = require("../utils/bedrock");
var _constants = require("./constants");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getMessageContentAndRole = (prompt, role = 'user') => ({
  content: prompt,
  role: role === 'human' ? 'user' : role
});
exports.getMessageContentAndRole = getMessageContentAndRole;
function _formatMessages(messages) {
  if (!messages.length) {
    throw new Error('No messages provided.');
  }
  return messages.map(message => {
    if (typeof message.content !== 'string') {
      throw new Error('Multimodal messages are not supported.');
    }
    return getMessageContentAndRole(message.content, message._getType());
  });
}
var _actionsClient = /*#__PURE__*/new WeakMap();
var _connectorId = /*#__PURE__*/new WeakMap();
var _logger = /*#__PURE__*/new WeakMap();
var _traceId = /*#__PURE__*/new WeakMap();
var _signal = /*#__PURE__*/new WeakMap();
var _maxTokens = /*#__PURE__*/new WeakMap();
class ActionsClientSimpleChatModel extends _chat_models.SimpleChatModel {
  constructor({
    actionsClient,
    connectorId,
    llmType,
    logger,
    model,
    temperature,
    signal,
    streaming,
    maxTokens,
    telemetryMetadata
  }) {
    super({});
    _classPrivateFieldInitSpec(this, _actionsClient, void 0);
    _classPrivateFieldInitSpec(this, _connectorId, void 0);
    _classPrivateFieldInitSpec(this, _logger, void 0);
    _classPrivateFieldInitSpec(this, _traceId, void 0);
    _classPrivateFieldInitSpec(this, _signal, void 0);
    _classPrivateFieldInitSpec(this, _maxTokens, void 0);
    (0, _defineProperty2.default)(this, "llmType", void 0);
    (0, _defineProperty2.default)(this, "streaming", void 0);
    (0, _defineProperty2.default)(this, "model", void 0);
    (0, _defineProperty2.default)(this, "temperature", void 0);
    (0, _defineProperty2.default)(this, "telemetryMetadata", void 0);
    _classPrivateFieldSet(_actionsClient, this, actionsClient);
    _classPrivateFieldSet(_connectorId, this, connectorId);
    _classPrivateFieldSet(_traceId, this, (0, _uuid.v4)());
    _classPrivateFieldSet(_logger, this, logger);
    _classPrivateFieldSet(_signal, this, signal);
    _classPrivateFieldSet(_maxTokens, this, maxTokens);
    this.llmType = llmType !== null && llmType !== void 0 ? llmType : 'ActionsClientSimpleChatModel';
    this.model = model;
    this.temperature = temperature;
    this.streaming = streaming;
    this.telemetryMetadata = telemetryMetadata;
  }
  _llmType() {
    return this.llmType;
  }

  // Model type needs to be `base_chat_model` to work with LangChain OpenAI Tools
  // We may want to make this configurable (ala _llmType) if different agents end up requiring different model types
  // See: https://github.com/langchain-ai/langchainjs/blob/fb699647a310c620140842776f4a7432c53e02fa/langchain/src/agents/openai/index.ts#L185
  _modelType() {
    return 'base_chat_model';
  }
  async _call(messages, options, runManager) {
    var _this$telemetryMetada, _this$telemetryMetada2;
    const formattedMessages = _formatMessages(messages);
    _classPrivateFieldGet(_logger, this).debug(() => `ActionsClientSimpleChatModel#_call\ntraceId: ${_classPrivateFieldGet(_traceId, this)}\nassistantMessage:\n${JSON.stringify(formattedMessages)} `);
    // create a new connector request body with the assistant message:
    const requestBody = {
      actionId: _classPrivateFieldGet(_connectorId, this),
      params: {
        subAction: this.streaming ? 'invokeStream' : 'invokeAI',
        subActionParams: {
          model: this.model,
          messages: formattedMessages,
          telemetryMetadata: {
            pluginId: (_this$telemetryMetada = this.telemetryMetadata) === null || _this$telemetryMetada === void 0 ? void 0 : _this$telemetryMetada.pluginId,
            aggregateBy: (_this$telemetryMetada2 = this.telemetryMetadata) === null || _this$telemetryMetada2 === void 0 ? void 0 : _this$telemetryMetada2.aggregateBy
          },
          ...(0, _constants.getDefaultArguments)(this.llmType, this.temperature, options.stop, _classPrivateFieldGet(_maxTokens, this))
        }
      }
    };
    const actionResult = await _classPrivateFieldGet(_actionsClient, this).execute(requestBody);
    if (actionResult.status === 'error') {
      const error = new Error(`ActionsClientSimpleChatModel: action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
      if (actionResult !== null && actionResult !== void 0 && actionResult.serviceMessage) {
        error.name = actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage;
      }
      throw error;
    }
    if (!this.streaming) {
      const content = (0, _fp.get)('data.message', actionResult);
      if (typeof content !== 'string') {
        throw new Error(`ActionsClientSimpleChatModel: content should be a string, but it had an unexpected type: ${typeof content}`);
      }
      return content; // per the contact of _call, return a string
    }
    const readable = (0, _fp.get)('data', actionResult);
    if (typeof (readable === null || readable === void 0 ? void 0 : readable.read) !== 'function') {
      throw new Error('Action result status is error: result is not streamable');
    }
    let currentOutput = '';
    let finalOutputIndex = -1;
    const finalOutputStartToken = '"action":"FinalAnswer","action_input":"';
    let streamingFinished = false;
    const finalOutputStopRegex = /(?<!\\)"/;
    const handleLLMNewToken = async token => {
      if (finalOutputIndex === -1) {
        currentOutput += token;
        // Remove whitespace to simplify parsing
        const noWhitespaceOutput = currentOutput.replace(/\s/g, '');
        if (noWhitespaceOutput.includes(finalOutputStartToken)) {
          const nonStrippedToken = '"action_input": "';
          finalOutputIndex = currentOutput.indexOf(nonStrippedToken);
          const contentStartIndex = finalOutputIndex + nonStrippedToken.length;
          const extraOutput = currentOutput.substring(contentStartIndex);
          if (extraOutput.length > 0) {
            await (runManager === null || runManager === void 0 ? void 0 : runManager.handleLLMNewToken(extraOutput));
          }
        }
      } else if (!streamingFinished) {
        const finalOutputEndIndex = token.search(finalOutputStopRegex);
        if (finalOutputEndIndex !== -1) {
          streamingFinished = true;
          const extraOutput = token.substring(0, finalOutputEndIndex);
          streamingFinished = true;
          if (extraOutput.length > 0) {
            await (runManager === null || runManager === void 0 ? void 0 : runManager.handleLLMNewToken(extraOutput));
          }
        } else {
          await (runManager === null || runManager === void 0 ? void 0 : runManager.handleLLMNewToken(token));
        }
      }
    };
    const streamParser = this.llmType === 'bedrock' ? _bedrock.parseBedrockStream : _gemini.parseGeminiStream;
    const parsed = await streamParser(readable, _classPrivateFieldGet(_logger, this), _classPrivateFieldGet(_signal, this), handleLLMNewToken);
    return parsed; // per the contact of _call, return a string
  }
  async *_streamResponseChunks(messages, options, runManager) {
    var _this$telemetryMetada3, _this$telemetryMetada4;
    const formattedMessages = _formatMessages(messages);
    _classPrivateFieldGet(_logger, this).debug(() => `ActionsClientSimpleChatModel#stream\ntraceId: ${_classPrivateFieldGet(_traceId, this)}\nassistantMessage:\n${JSON.stringify(formattedMessages)} `);
    // create a new connector request body with the assistant message:
    const requestBody = {
      actionId: _classPrivateFieldGet(_connectorId, this),
      params: {
        subAction: 'invokeStream',
        subActionParams: {
          model: this.model,
          messages: formattedMessages,
          telemetryMetadata: {
            pluginId: (_this$telemetryMetada3 = this.telemetryMetadata) === null || _this$telemetryMetada3 === void 0 ? void 0 : _this$telemetryMetada3.pluginId,
            aggregateBy: (_this$telemetryMetada4 = this.telemetryMetadata) === null || _this$telemetryMetada4 === void 0 ? void 0 : _this$telemetryMetada4.aggregateBy
          },
          ...(0, _constants.getDefaultArguments)(this.llmType, this.temperature, options.stop, _classPrivateFieldGet(_maxTokens, this))
        }
      }
    };
    const actionResult = await _classPrivateFieldGet(_actionsClient, this).execute(requestBody);
    if (actionResult.status === 'error') {
      const error = new Error(`ActionsClientSimpleChatModel: action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
      if (actionResult !== null && actionResult !== void 0 && actionResult.serviceMessage) {
        error.name = actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage;
      }
      throw error;
    }
    const readable = (0, _fp.get)('data', actionResult);
    if (typeof (readable === null || readable === void 0 ? void 0 : readable.read) !== 'function') {
      throw new Error('Action result status is error: result is not streamable');
    }
    const streamParser = this.llmType === 'bedrock' ? _bedrock.parseBedrockStreamAsAsyncIterator : _gemini.parseGeminiStreamAsAsyncIterator;
    for await (const token of streamParser(readable, _classPrivateFieldGet(_logger, this), _classPrivateFieldGet(_signal, this))) {
      yield new _outputs.ChatGenerationChunk({
        message: new _messages.AIMessageChunk({
          content: token
        }),
        text: token
      });
      await (runManager === null || runManager === void 0 ? void 0 : runManager.handleLLMNewToken(token));
    }
  }
}
exports.ActionsClientSimpleChatModel = ActionsClientSimpleChatModel;