"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.interceptInteractionUserRecordSavedObject = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const interceptInteractionV1 = _configSchema.schema.object({
  userId: _configSchema.schema.string(),
  triggerId: _configSchema.schema.string(),
  metadata: _configSchema.schema.object({
    lastInteractedInterceptId: _configSchema.schema.number()
  }, {
    unknowns: 'allow'
  })
});
const interceptInteractionUserRecordSavedObject = exports.interceptInteractionUserRecordSavedObject = {
  name: 'intercept_interaction_record',
  hidden: true,
  hiddenFromHttpApis: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {}
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        forwardCompatibility: interceptInteractionV1.extends({}, {
          unknowns: 'ignore'
        }),
        create: interceptInteractionV1
      }
    }
  }
};