"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHtmlId = useHtmlId;
var _eui = require("@elastic/eui");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Generates an ID that can be used for HTML elements.
 *
 * @param prefix Prefix of the id to be generated
 * @param suffix Suffix of the id to be generated
 *
 * @example
 * ```typescript
 * const titleId = useHtmlId('changePasswordForm', 'title');
 *
 * <EuiForm aria-labelledby={titleId}>
 *   <h2 id={titleId}>Change password</h2>
 * </EuiForm>
 * ```
 */
function useHtmlId(prefix, suffix) {
  return (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)(prefix)(suffix), [prefix, suffix]);
}