"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getComponentDataBodySchema = exports.getComponentData = void 0;
var _path = require("path");
var _repoInfo = require("@kbn/repo-info");
var _configSchema = require("@kbn/config-schema");
var _get_component_codeowners = require("../../lib/codeowners/get_component_codeowners");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getComponentDataBodySchema = exports.getComponentDataBodySchema = _configSchema.schema.object({
  path: _configSchema.schema.string({
    minLength: 1
  })
});

/**
 * Options for {@link getComponentData}.
 */

/**
 * Response structure for {@link getComponentData}.
 */

/**
 * Get data about a component at a given path.
 * @async
 * @internal
 * @param {GetComponentDataOptions} options
 * @param {KibanaRequest<unknown, unknown, GetComponentDataRequestBody>} options.req {@link KibanaRequest}
 * @param {KibanaResponseFactory} options.res {@link KibanaResponseFactory}
 * @param {Logger} options.logger {@link Logger}
 * @returns {Promise<IKibanaResponse<GetComponentDataResponse>>} Resolves with {@link GetComponentDataResponse component data}.
 */
const getComponentData = async ({
  req,
  res,
  logger
}) => {
  const {
    path
  } = req.body;
  logger.debug(`Inspecting component at path: ${path}`);
  const relativePath = path.slice(_repoInfo.REPO_ROOT.length + _path.sep.length);
  const baseFileName = relativePath.split(_path.sep).pop() || '';
  const codeowners = (0, _get_component_codeowners.getComponentCodeowners)(relativePath);
  return res.ok({
    body: {
      codeowners,
      relativePath,
      baseFileName
    }
  });
};
exports.getComponentData = getComponentData;