"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputControlVisPlugin = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _input_control_fn = require("./input_control_fn");
var _input_control_vis_renderer = require("./input_control_vis_renderer");
var _input_control_vis_type = require("./input_control_vis_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/** @internal */

/** @internal */

/** @internal */
class InputControlVisPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    visualizations,
    unifiedSearch,
    data
  }) {
    const visualizationDependencies = {
      core,
      unifiedSearch,
      getSettings: async () => {
        const {
          timeout,
          terminateAfter
        } = unifiedSearch.autocomplete.getAutocompleteSettings();
        return {
          autocompleteTimeout: timeout,
          autocompleteTerminateAfter: terminateAfter
        };
      },
      data
    };
    expressions.registerFunction(_input_control_fn.createInputControlVisFn);
    expressions.registerRenderer((0, _input_control_vis_renderer.getInputControlVisRenderer)(visualizationDependencies));
    const {
      readOnly
    } = this.initializerContext.config.get();
    visualizations.createBaseVisualization((0, _input_control_vis_type.createInputControlVisTypeDefinition)(visualizationDependencies, Boolean(readOnly)));
  }
  start(core, {
    uiActions
  }) {
    uiActions.addTriggerActionAsync(_public.PANEL_BADGE_TRIGGER, 'ACTION_DEPRECATION_BADGE', async () => {
      const {
        inputControlDeprecationBadge
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./deprecation_badge')));
      return inputControlDeprecationBadge;
    });
    return {};
  }
}
exports.InputControlVisPlugin = InputControlVisPlugin;