"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getControlPanelConfigs = void 0;
var _common = require("@kbn/metrics-data-access-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonControlPanelConfig = {
  [_common.CLOUD_PROVIDER]: {
    order: 1,
    width: 'medium',
    grow: false,
    type: 'optionsListControl',
    fieldName: _common.CLOUD_PROVIDER,
    title: 'Cloud Provider'
  },
  [_common.SERVICE_NAME]: {
    order: 2,
    width: 'medium',
    grow: false,
    type: 'optionsListControl',
    fieldName: _common.SERVICE_NAME,
    title: 'Service Name'
  }
};
const controlPanelConfig = {
  ecs: {
    [_common.HOST_OS_NAME]: {
      order: 0,
      width: 'medium',
      grow: false,
      type: 'optionsListControl',
      fieldName: _common.HOST_OS_NAME,
      title: 'Operating System'
    }
  },
  semconv: {
    [_common.OS_NAME]: {
      order: 0,
      width: 'medium',
      grow: false,
      type: 'optionsListControl',
      fieldName: _common.OS_NAME,
      title: 'Operating System'
    }
  }
};
const replaceableControlPanels = {
  ecs: {
    [_common.OS_NAME]: {
      key: _common.HOST_OS_NAME,
      control: controlPanelConfig.ecs[_common.HOST_OS_NAME]
    }
  },
  semconv: {
    [_common.HOST_OS_NAME]: {
      key: _common.OS_NAME,
      control: controlPanelConfig.semconv[_common.OS_NAME]
    }
  }
};
const getControlPanelConfigs = schema => {
  if (!schema) {
    return {
      controls: {
        ...controlPanelConfig.ecs,
        ...commonControlPanelConfig
      }
    };
  }
  return {
    controls: {
      ...controlPanelConfig[schema],
      ...commonControlPanelConfig
    },
    replace: replaceableControlPanels[schema]
  };
};
exports.getControlPanelConfigs = getControlPanelConfigs;