"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryExampleMessages = void 0;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _log_entry_examples_empty_indicator = require("./log_entry_examples_empty_indicator");
var _log_entry_examples_failure_indicator = require("./log_entry_examples_failure_indicator");
var _log_entry_examples_loading_indicator = require("./log_entry_examples_loading_indicator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_entry_examples/log_entry_examples.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LogEntryExampleMessages = ({
  isLoading,
  hasFailedLoading,
  exampleCount,
  hasResults,
  onReload,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_log_entry_examples_loading_indicator.LogEntryExampleMessagesLoadingIndicator, {
    exampleCount: exampleCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }) : hasFailedLoading ? /*#__PURE__*/_react.default.createElement(_log_entry_examples_failure_indicator.LogEntryExampleMessagesFailureIndicator, {
    onRetry: onReload,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }) : !hasResults ? /*#__PURE__*/_react.default.createElement(_log_entry_examples_empty_indicator.LogEntryExampleMessagesEmptyIndicator, {
    onReload: onReload,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }) : children);
};
exports.LogEntryExampleMessages = LogEntryExampleMessages;
const Wrapper = _styled.default.div`
  align-items: stretch;
  flex-direction: column;
  flex: 1 0 0%;
  overflow: hidden;
  padding-top: 1px; // Buffer for the "Reload" buttons' hover state
`;