"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRowsWithPins = exports.getAllFields = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllFields = (metadata, schema) => {
  var _metadata$info$agent, _metadata$info$cloud, _metadata$info$host, _metadata$info5, _metadata$info$contai, _metadata$info6;
  if (!(metadata !== null && metadata !== void 0 && metadata.info)) return [];
  const mapNestedProperties = (category, property) => {
    var _get;
    const fieldsByCategory = (_get = (0, _lodash.get)(metadata === null || metadata === void 0 ? void 0 : metadata.info, category)) !== null && _get !== void 0 ? _get : {};
    if (Object.hasOwn(fieldsByCategory, property)) {
      const value = fieldsByCategory[property];
      if (typeof value === 'boolean') {
        return {
          name: `${category}.${property}`,
          value: String(value)
        };
      }
      if (typeof value === 'string' || Array.isArray(value)) {
        return {
          name: `${category}.${property}`,
          value
        };
      } else {
        return Object.entries(value !== null && value !== void 0 ? value : {}).map(([prop, subProp]) => {
          if (!Array.isArray(subProp) && (0, _lodash.isPlainObject)(subProp)) {
            return {
              name: '',
              value: ''
            };
          }
          return {
            name: `${category}.${property}.${prop}`,
            value: subProp
          };
        }).filter(({
          name
        }) => name);
      }
    }
    return [];
  };
  const additionalCategories = [];
  if (schema === 'semconv') {
    var _metadata$info$resour, _metadata$info, _metadata$info$resour2, _metadata$info$resour3, _metadata$info$resour4, _metadata$info2, _metadata$info2$resou, _metadata$info2$resou2, _metadata$info$resour5, _metadata$info3, _metadata$info3$resou, _metadata$info3$resou2, _metadata$info$resour6, _metadata$info4, _metadata$info4$resou, _metadata$info4$resou2;
    const osResourceAttributes = Object.keys((_metadata$info$resour = metadata === null || metadata === void 0 ? void 0 : (_metadata$info = metadata.info) === null || _metadata$info === void 0 ? void 0 : (_metadata$info$resour2 = _metadata$info.resource) === null || _metadata$info$resour2 === void 0 ? void 0 : (_metadata$info$resour3 = _metadata$info$resour2.attributes) === null || _metadata$info$resour3 === void 0 ? void 0 : _metadata$info$resour3.os) !== null && _metadata$info$resour !== void 0 ? _metadata$info$resour : {}).flatMap(prop => mapNestedProperties('resource.attributes.os', prop));
    const hostResourceAttributes = Object.keys((_metadata$info$resour4 = metadata === null || metadata === void 0 ? void 0 : (_metadata$info2 = metadata.info) === null || _metadata$info2 === void 0 ? void 0 : (_metadata$info2$resou = _metadata$info2.resource) === null || _metadata$info2$resou === void 0 ? void 0 : (_metadata$info2$resou2 = _metadata$info2$resou.attributes) === null || _metadata$info2$resou2 === void 0 ? void 0 : _metadata$info2$resou2.host) !== null && _metadata$info$resour4 !== void 0 ? _metadata$info$resour4 : {}).flatMap(prop => mapNestedProperties('resource.attributes.host', prop));
    const agentResourceAttributes = Object.keys((_metadata$info$resour5 = metadata === null || metadata === void 0 ? void 0 : (_metadata$info3 = metadata.info) === null || _metadata$info3 === void 0 ? void 0 : (_metadata$info3$resou = _metadata$info3.resource) === null || _metadata$info3$resou === void 0 ? void 0 : (_metadata$info3$resou2 = _metadata$info3$resou.attributes) === null || _metadata$info3$resou2 === void 0 ? void 0 : _metadata$info3$resou2.agent) !== null && _metadata$info$resour5 !== void 0 ? _metadata$info$resour5 : {}).flatMap(prop => mapNestedProperties('resource.attributes.agent', prop));
    const cloudResourceAttributes = Object.keys((_metadata$info$resour6 = metadata === null || metadata === void 0 ? void 0 : (_metadata$info4 = metadata.info) === null || _metadata$info4 === void 0 ? void 0 : (_metadata$info4$resou = _metadata$info4.resource) === null || _metadata$info4$resou === void 0 ? void 0 : (_metadata$info4$resou2 = _metadata$info4$resou.attributes) === null || _metadata$info4$resou2 === void 0 ? void 0 : _metadata$info4$resou2.cloud) !== null && _metadata$info$resour6 !== void 0 ? _metadata$info$resour6 : {}).flatMap(prop => mapNestedProperties('resource.attributes.cloud', prop));
    additionalCategories.push(...osResourceAttributes, ...hostResourceAttributes, ...agentResourceAttributes, ...cloudResourceAttributes);
  }
  const agent = Object.keys((_metadata$info$agent = metadata.info.agent) !== null && _metadata$info$agent !== void 0 ? _metadata$info$agent : {}).flatMap(prop => mapNestedProperties('agent', prop));
  const cloud = Object.keys((_metadata$info$cloud = metadata.info.cloud) !== null && _metadata$info$cloud !== void 0 ? _metadata$info$cloud : {}).flatMap(prop => mapNestedProperties('cloud', prop));
  const host = Object.keys((_metadata$info$host = metadata === null || metadata === void 0 ? void 0 : (_metadata$info5 = metadata.info) === null || _metadata$info5 === void 0 ? void 0 : _metadata$info5.host) !== null && _metadata$info$host !== void 0 ? _metadata$info$host : {}).flatMap(prop => mapNestedProperties('host', prop));
  const container = Object.keys((_metadata$info$contai = metadata === null || metadata === void 0 ? void 0 : (_metadata$info6 = metadata.info) === null || _metadata$info6 === void 0 ? void 0 : _metadata$info6.container) !== null && _metadata$info$contai !== void 0 ? _metadata$info$contai : {}).flatMap(prop => mapNestedProperties('container', prop));
  return prune([...host, ...container, ...agent, ...cloud, ...additionalCategories]);
};
exports.getAllFields = getAllFields;
const prune = fields => fields.filter(f => !!(f !== null && f !== void 0 && f.value));
const getRowsWithPins = (rows, pinnedItems) => {
  if (pinnedItems.length > 0) {
    const {
      pinned,
      other
    } = rows.reduce((acc, row) => {
      (pinnedItems.includes(row.name) ? acc.pinned : acc.other).push(row);
      return acc;
    }, {
      pinned: [],
      other: []
    });
    return [...pinned, ...other];
  }
};
exports.getRowsWithPins = getRowsWithPins;