"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInferenceContext = createInferenceContext;
var _api = require("@opentelemetry/api");
var _baggage = require("./baggage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createInferenceContext() {
  var _baggage$getEntry;
  const ctx = _api.context.active();
  let baggage = _api.propagation.getBaggage(ctx);
  let isRoot = false;
  if (!baggage) {
    isRoot = true;
    baggage = _api.propagation.createBaggage({
      [_baggage.BAGGAGE_TRACKING_BEACON_KEY]: {
        value: _baggage.BAGGAGE_TRACKING_BEACON_VALUE
      }
    });
  } else if (((_baggage$getEntry = baggage.getEntry(_baggage.BAGGAGE_TRACKING_BEACON_KEY)) === null || _baggage$getEntry === void 0 ? void 0 : _baggage$getEntry.value) !== _baggage.BAGGAGE_TRACKING_BEACON_VALUE) {
    isRoot = true;
    baggage = baggage.setEntry(_baggage.BAGGAGE_TRACKING_BEACON_KEY, {
      value: _baggage.BAGGAGE_TRACKING_BEACON_VALUE
    });
  }

  // create a new context with the updated baggage
  let parentContext = _api.propagation.setBaggage(ctx, baggage);
  if (isRoot) {
    // Remove any pre-existing span context so new work starts a fresh trace
    parentContext = _api.trace.deleteSpan(parentContext);
  }
  return {
    context: parentContext,
    baggage,
    isRoot
  };
}