"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInferenceAdapter = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _openai = require("./openai");
var _gemini = require("./gemini");
var _bedrock = require("./bedrock");
var _inference = require("./inference");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInferenceAdapter = connectorType => {
  switch (connectorType) {
    case _inferenceCommon.InferenceConnectorType.OpenAI:
      return _openai.openAIAdapter;
    case _inferenceCommon.InferenceConnectorType.Gemini:
      return _gemini.geminiAdapter;
    case _inferenceCommon.InferenceConnectorType.Bedrock:
      return _bedrock.bedrockClaudeAdapter;
    case _inferenceCommon.InferenceConnectorType.Inference:
      return _inference.inferenceAdapter;
  }
  return undefined;
};
exports.getInferenceAdapter = getInferenceAdapter;