"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChatCompleteRestApi = createChatCompleteRestApi;
var _rxjs = require("rxjs");
var _retry_with_exponential_backoff = require("../utils/retry_with_exponential_backoff");
var _error_retry_filter = require("../utils/error_retry_filter");
var _combine_signal = require("../utils/combine_signal");
var _http_response_into_observable = require("../utils/http_response_into_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createChatCompleteRestApi({
  fetch,
  signal
}) {
  return ({
    connectorId,
    messages,
    system,
    toolChoice,
    tools,
    temperature,
    modelName,
    functionCalling,
    stream,
    abortSignal,
    maxRetries,
    metadata,
    retryConfiguration
  }) => {
    const body = {
      connectorId,
      system,
      messages,
      toolChoice,
      tools,
      temperature,
      modelName,
      functionCalling,
      retryConfiguration: undefined,
      maxRetries,
      metadata
    };
    function retry() {
      return (0, _retry_with_exponential_backoff.retryWithExponentialBackoff)({
        maxRetry: maxRetries,
        backoffMultiplier: retryConfiguration === null || retryConfiguration === void 0 ? void 0 : retryConfiguration.backoffMultiplier,
        errorFilter: (0, _error_retry_filter.getRetryFilter)(retryConfiguration === null || retryConfiguration === void 0 ? void 0 : retryConfiguration.retryOn),
        initialDelay: retryConfiguration === null || retryConfiguration === void 0 ? void 0 : retryConfiguration.initialDelay
      });
    }
    if (stream) {
      return (0, _rxjs.from)(fetch('/internal/inference/chat_complete/stream', {
        method: 'POST',
        asResponse: true,
        rawResponse: true,
        body: JSON.stringify(body),
        signal: (0, _combine_signal.combineSignal)(signal, abortSignal)
      })).pipe((0, _http_response_into_observable.httpResponseIntoObservable)(), retry());
    } else {
      return (0, _rxjs.lastValueFrom)((0, _rxjs.defer)(() => fetch('/internal/inference/chat_complete', {
        method: 'POST',
        body: JSON.stringify(body),
        signal: (0, _combine_signal.combineSignal)(signal, abortSignal)
      })).pipe(retry()));
    }
  };
}