"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeAllocation = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../../shared_imports");
var _form = require("../../../../../form");
var _learn_more_link = require("../../../../learn_more_link");
var _node_attrs_details = require("./node_attrs_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/data_tier_allocation_field/components/node_allocation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  allocateToDataNodesOption: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.nodeAllocation.allocateToDataNodesOption', {
    defaultMessage: 'Any data node'
  })
};
const NodeAllocation = ({
  phase,
  nodes,
  isLoading,
  isCloudEnabled,
  isUsingDeprecatedDataRoleConfig
}) => {
  const allocationNodeAttributePath = `_meta.${phase}.allocationNodeAttribute`;
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [allocationNodeAttributePath]
  });
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  const shardAllocationSettingsUrl = docLinks.links.elasticsearch.shardAllocationSettings;
  const selectedAllocationNodeAttribute = (0, _lodash.get)(formData, allocationNodeAttributePath);
  const [selectedNodeAttrsForDetails, setSelectedNodeAttrsForDetails] = (0, _react.useState)(null);
  const nodeOptions = Object.keys(nodes).map(attrs => ({
    text: `${attrs} (${nodes[attrs].length})`,
    value: attrs
  }));
  nodeOptions.sort((a, b) => a.value.localeCompare(b.value));
  let nodeAllocationOptions = [];

  // On Cloud, allocating to data tiers and allocating to data nodes is mutually exclusive. So we
  // only let users select this option if they're using data nodes. Otherwise we remove it.
  //
  // On prem, users should have the freedom to choose this option, even if they're using node roles.
  // So we always give them this option.
  if (!isCloudEnabled || isUsingDeprecatedDataRoleConfig) {
    const allocateToDataNodesOption = {
      text: i18nTexts.allocateToDataNodesOption,
      value: ''
    };
    nodeAllocationOptions.push(allocateToDataNodesOption);
  }
  nodeAllocationOptions = nodeAllocationOptions.concat(nodeOptions);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.nodeAllocation.customOption.description",
    defaultMessage: "Use node attributes to control shard allocation. {learnMoreLink}.",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_learn_more_link.LearnMoreLink, {
        text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.indexLifecycleMgmt.editPolicy.learnAboutShardAllocationLink",
          defaultMessage: "Learn about shard allocation",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 21
          }
        }),
        docPath: shardAllocationSettingsUrl,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 17
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: `_meta.${phase}.allocationNodeAttribute`,
    component: _shared_imports.SelectField,
    config: {
      defaultValue: nodeAllocationOptions.length ? nodeAllocationOptions[0].value : ''
    },
    componentProps: {
      helpText: !!selectedAllocationNodeAttribute ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        style: {
          maxWidth: 400
        },
        "data-test-subj": `${phase}-viewNodeDetailsFlyoutButton`,
        flush: "left",
        onClick: () => setSelectedNodeAttrsForDetails(selectedAllocationNodeAttribute),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.viewNodeDetailsButton",
        defaultMessage: "View nodes with the selected attribute",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 15
        }
      })) : undefined,
      euiFieldProps: {
        'data-test-subj': `${phase}-selectedNodeAttrs`,
        options: nodeAllocationOptions,
        hasNoInitialSelection: false,
        isLoading
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), selectedNodeAttrsForDetails ? /*#__PURE__*/_react.default.createElement(_node_attrs_details.NodeAttrsDetails, {
    selectedNodeAttrs: selectedNodeAttrsForDetails,
    close: () => setSelectedNodeAttrsForDetails(null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }) : null);
};
exports.NodeAllocation = NodeAllocation;