"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsReadOnly = void 0;
var _constants = require("../../../common/constants");
var _shared_imports = require("../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsReadOnly = () => {
  const {
    services: {
      capabilities
    }
  } = (0, _shared_imports.useKibana)();
  const ilmCaps = capabilities[_constants.PLUGIN.ID];
  const savePermission = Boolean(ilmCaps.save);
  const showPermission = Boolean(ilmCaps.show);
  return !savePermission && showPermission;
};
exports.useIsReadOnly = useIsReadOnly;