"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18nReact = require("@kbn/i18n-react");
var _solution_panel = require("./solution_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/solutions_section/solutions_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const sortByOrder = ({
  order: orderA = 0
}, {
  order: orderB = 0
}) => orderA - orderB;
const SolutionsSection = ({
  addBasePath,
  solutions
}) => {
  if (solutions.length) {
    solutions = solutions.sort(sortByOrder);
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      bottomBorder: true,
      paddingSize: "xl",
      "aria-labelledby": "homeSolutions__title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "homeSolutions__title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.solutionsSection.sectionTitle",
      defaultMessage: "Pick your solution",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, solutions.map(solution => /*#__PURE__*/_react.default.createElement(_solution_panel.SolutionPanel, {
      addBasePath: addBasePath,
      key: solution.id,
      solution: solution,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }))));
  } else {
    return null;
  }
};
exports.SolutionsSection = SolutionsSection;