"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOKEN_SPLIT_CHARS = exports.PATTERN_PRECEDENCE = exports.PATTERN_OVERRIDES = exports.GROK_REGEX_MAP = exports.FIRST_PASS_PATTERNS = exports.COLLAPSIBLE_PATTERNS = exports.ALL_CAPTURE_CHARS = void 0;
var _lodash = require("lodash");
var _mask_capturing_brackets = require("./tokenization/mask_capturing_brackets");
var _mask_quotes = require("./tokenization/mask_quotes");
var _grok_patterns = require("./grok_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALL_PAIRS = {
  ..._mask_quotes.QUOTE_PAIRS,
  ..._mask_capturing_brackets.BRACKET_PAIRS
};
const ALL_CAPTURE_CHARS = exports.ALL_CAPTURE_CHARS = (0, _lodash.uniq)(Object.entries(ALL_PAIRS).flat());

// ^ , $ , \ , . , * , + , ? , ( , ) , [ , ] , { , } , and |
const TOKEN_SPLIT_CHARS = exports.TOKEN_SPLIT_CHARS = [':', '|', ',', ';', '.', '-', '@', '/', '\\', ...ALL_CAPTURE_CHARS, ' '];
const sanitize = s => s.replaceAll(/[.^$*+?()\[\]{}|\\]/g, '\\$&');
const splitCharsRegexes = Object.fromEntries(TOKEN_SPLIT_CHARS.map(token => {
  return [token, `(${[token].map(val => sanitize(val)).join('|')})`];
}));
const PATTERN_OVERRIDES = exports.PATTERN_OVERRIDES = {
  CAPTUREGROUP: '(%\\{[A-Za-z0-9_]+:\\d+\\})',
  ...splitCharsRegexes
};
const GROK_REGEX_MAP = exports.GROK_REGEX_MAP = (0, _grok_patterns.buildGrokRegexMap)(PATTERN_OVERRIDES);
const PATTERN_PRECEDENCE = exports.PATTERN_PRECEDENCE = ['LOGLEVEL', 'UUID', 'URN', 'CISCOMAC',
// also matched by `MAC` but prefer specificity
'WINDOWSMAC',
// also matched by `MAC` but prefer specificity
'COMMONMAC',
// also matched by `MAC` but prefer specificity
'MAC', 'IPV4',
// also matched by `IP` but prefer specificity
'IPV6',
// also matched by `IP` but prefer specificity
'IP', 'HOSTPORT',
// 'UNIXPATH', // also matched by `PATH`
// 'WINPATH', // also matched by `PATH`
// 'PATH',
'TTY',
// 'URI',
'TIMESTAMP_ISO8601', 'DATESTAMP', 'DATESTAMP_RFC822', 'DATESTAMP_RFC2822', 'DATESTAMP_OTHER', 'DATESTAMP_EVENTLOG', 'SYSLOGTIMESTAMP', 'SYSLOGFACILITY', 'HTTPDATE', 'EMAILADDRESS', 'DAY', 'MONTH', 'TIME', 'DATE_US',
// also matched by `DATE` but prefer specificity
'DATE_EU',
// also matched by `DATE` but prefer specificity
'DATE',
// 'MONTHNUM2', // too short, not useful
// 'MONTHNUM', // too short, not useful
// 'MONTHDAY', // too short, not useful
// 'YEAR', // too short, not useful
'INT',
// 'HOSTNAME', // too generic, not useful
...TOKEN_SPLIT_CHARS, 'SPACE', 'WORD', 'NOTSPACE', 'DATA', 'GREEDYDATA'
// nothing else
];
const COLLAPSIBLE_PATTERNS = exports.COLLAPSIBLE_PATTERNS = ['WORD', 'NOTSPACE', 'DATA', 'GREEDYDATA'];
const unsortedFirstPassPatterns = ['DATESTAMP_EVENTLOG', 'DATESTAMP_OTHER', 'DATESTAMP_RFC2822', 'DATESTAMP_RFC822', 'HTTPDATE', 'IP', 'MAC', 'SYSLOGTIMESTAMP', 'TIMESTAMP_ISO8601', 'TTY', 'URN', 'UUID'];
const FIRST_PASS_PATTERNS = exports.FIRST_PASS_PATTERNS = (0, _lodash.orderBy)(unsortedFirstPassPatterns, pattern => {
  const idx = PATTERN_PRECEDENCE.indexOf(pattern);
  return idx === -1 ? Number.POSITIVE_INFINITY : idx;
});