"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyIconStyles = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const legacyIconStyles = exports.legacyIconStyles = {
  base: ({
    euiTheme
  }) => (0, _react.css)`
    width: calc(${euiTheme.size.s} * 2);
  `,
  list: ({
    euiTheme
  }) => (0, _react.css)`
    margin-right: ${euiTheme.size.m};
  `,
  pickable: ({
    euiTheme
  }) => (0, _react.css)`
    margin: ${euiTheme.size.xs};
    cursor: pointer;
    opacity: 0.7;

    &:hover,
    &:focus {
      transform: scale(1.4);
      opacity: 1;
    }
  `,
  selected: (0, _react.css)`
    transform: scale(1.4);
    opacity: 1;
  `
};