"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultPreference = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultPrefStorageKey = 'globalSearch:defaultPref';

/**
 * Returns the default {@link GlobalSearchFindOptions.preference | preference} value.
 *
 * The implementation is based on the sessionStorage, which ensure the default value for a session/tab will remain the same.
 */
const getDefaultPreference = (storage = window.sessionStorage) => {
  let pref = storage.getItem(defaultPrefStorageKey);
  if (pref) {
    return pref;
  }
  pref = (0, _uuid.v4)();
  storage.setItem(defaultPrefStorageKey, pref);
  return pref;
};
exports.getDefaultPreference = getDefaultPreference;