"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepRemoveLegacyTemplates = stepRemoveLegacyTemplates;
var _remove_legacy = require("../../../elasticsearch/template/remove_legacy");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepRemoveLegacyTemplates(context) {
  const {
    esClient,
    packageInstallContext,
    logger
  } = context;
  const {
    packageInfo
  } = packageInstallContext;
  try {
    await (0, _utils.withPackageSpan)('Remove legacy templates', () => (0, _remove_legacy.removeLegacyTemplates)({
      packageInfo,
      esClient,
      logger
    }));
  } catch (e) {
    logger.warn(`Error removing legacy templates: ${e.message}`);
  }
}