"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migratePackagePolicyToV81102 = exports.migratePackagePolicyEvictionsFromV81102 = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migratePackagePolicyToV81102 = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    var _policy$meta;
    const policy = input.config.policy.value;
    const newMetaValues = {
      license_uuid: policy !== null && policy !== void 0 && (_policy$meta = policy.meta) !== null && _policy$meta !== void 0 && _policy$meta.license_uid ? policy.meta.license_uid : ''
    };
    policy.meta = policy !== null && policy !== void 0 && policy.meta ? {
      ...policy.meta,
      ...newMetaValues
    } : newMetaValues;
  }
  return {
    attributes: {
      inputs: updatedPackagePolicyDoc.attributes.inputs
    }
  };
};
exports.migratePackagePolicyToV81102 = migratePackagePolicyToV81102;
const migratePackagePolicyEvictionsFromV81102 = unknownAttributes => {
  var _attributes$package;
  const attributes = unknownAttributes;
  if (((_attributes$package = attributes.package) === null || _attributes$package === void 0 ? void 0 : _attributes$package.name) !== 'endpoint') {
    return attributes;
  }
  const updatedAttributes = attributes;
  const input = updatedAttributes.inputs[0];
  if (input && input.config) {
    const policy = input.config.policy.value;
    policy.meta = (0, _lodash.omit)(policy.meta, ['license_uuid']);
  }
  return updatedAttributes;
};
exports.migratePackagePolicyEvictionsFromV81102 = migratePackagePolicyEvictionsFromV81102;