"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevtoolsRequestFlyoutButton = exports.ApiRequestFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/devtools_request_flyout/devtools_request_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DevtoolsRequestFlyoutButton = ({
  isDisabled,
  request,
  title,
  description,
  btnProps = {}
}) => {
  const flyoutRef = (0, _react.useRef)();
  const services = (0, _hooks.useStartServices)();
  const onClick = (0, _react.useCallback)(() => {
    const flyout = services.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: services,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(ApiRequestFlyout, {
      closeFlyout: () => flyout.close(),
      request: request,
      title: title,
      description: description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 11
      }
    })), services));
    flyoutRef.current = flyout;
  }, [services, request, title, description]);
  _react.default.useEffect(() => {
    return () => {
      var _flyoutRef$current;
      (_flyoutRef$current = flyoutRef.current) === null || _flyoutRef$current === void 0 ? void 0 : _flyoutRef$current.close();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    onClick: onClick,
    isDisabled: isDisabled
  }, btnProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.apiRequestFlyout.openFlyoutButton",
    defaultMessage: "Preview API request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
};
exports.DevtoolsRequestFlyoutButton = DevtoolsRequestFlyoutButton;
const ApiRequestFlyout = ({
  closeFlyout,
  title = _i18n.i18n.translate('xpack.fleet.apiRequestFlyout.title', {
    defaultMessage: 'Kibana API Request'
  }),
  request,
  description = _i18n.i18n.translate('xpack.fleet.apiRequestFlyout.description', {
    defaultMessage: 'Perform these request against Kibana'
  })
}) => {
  const {
    docLinks,
    application,
    share
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_public.ViewApiRequestFlyout
  // @ts-expect-error ViewApiRequestFlyout title type only allow string
  , {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "baseline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.apiRequestFlyout.devtoolsRequestDescription",
      defaultMessage: "{learnMore}",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.fleet.api,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.apiRequestFlyout.learnMoreLink",
          defaultMessage: "Learn more about Fleet API",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 15
      }
    })))),
    description: description,
    request: request,
    closeFlyout: closeFlyout,
    application: application,
    urlService: share.url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
};
exports.ApiRequestFlyout = ApiRequestFlyout;