"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFleetServerHostsForm = useFleetServerHostsForm;
exports.validateFleetServerHosts = validateFleetServerHosts;
exports.validateName = validateName;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
var _services = require("../../../../../../../common/services");
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
var _types = require("../../../../../../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/fleet_server_hosts_flyout/use_fleet_server_host_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const URL_REGEX = /^(https):\/\/[^\s$.?#].[^\s]*$/gm;
const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.fleetServerHostsFlyout.confirmModalTitle",
  defaultMessage: "Save and deploy changes?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 3
  }
});
const ConfirmDescription = ({}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.fleetServerHostsFlyout.confirmModalText",
  defaultMessage: "This action will update agent policies enrolled in this Fleet Server. This action can not be undone. Are you sure you wish to continue?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 3
  }
});
function validateFleetServerHosts(value) {
  if (value.length === 0) {
    return [{
      message: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsEmptyError', {
        defaultMessage: 'At least one URL is required'
      })
    }];
  }
  const res = [];
  const hostIndexes = {};
  value.forEach((val, idx) => {
    if (!val) {
      res.push({
        message: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsRequiredError', {
          defaultMessage: 'Host URL is required'
        }),
        index: idx
      });
    } else if (!val.match(URL_REGEX)) {
      res.push({
        message: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsError', {
          defaultMessage: 'Invalid URL (must be an https URL)'
        }),
        index: idx
      });
    }
    const curIndexes = hostIndexes[val] || [];
    hostIndexes[val] = [...curIndexes, idx];
  });
  Object.values(hostIndexes).filter(({
    length
  }) => length > 1).forEach(indexes => {
    indexes.forEach(index => res.push({
      message: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsDuplicateError', {
        defaultMessage: 'Duplicate URL'
      }),
      index
    }));
  });
  if (res.length) {
    return res;
  }
  if (value.length && (0, _services.isDiffPathProtocol)(value)) {
    return [{
      message: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsDifferentPathOrProtocolError', {
        defaultMessage: 'Protocol and path must be the same for each URL'
      })
    }];
  }
}
function validateName(value) {
  if (!value || value === '') {
    return [_i18n.i18n.translate('xpack.fleet.settings.fleetServerHost.nameIsRequiredErrorMessage', {
      defaultMessage: 'Name is required'
    })];
  }
}
function useFleetServerHostsForm(fleetServerHost, onSuccess, defaultFleetServerHost) {
  var _ref, _fleetServerHost$name, _fleetServerHost$is_d, _fleetServerHost$prox, _fleetServerHost$ssl$, _fleetServerHost$ssl, _fleetServerHost$ssl$2, _fleetServerHost$ssl2, _fleetServerHost$ssl$3, _fleetServerHost$ssl3, _fleetServerHost$ssl$4, _fleetServerHost$ssl4, _fleetServerHost$ssl$5, _fleetServerHost$ssl5, _fleetServerHost$ssl$6, _fleetServerHost$ssl6, _secrets, _secrets$ssl, _secrets2, _secrets2$ssl, _fleetServerHost$ssl$7, _fleetServerHost$ssl7, _fleetServerHost$ssl$8, _fleetServerHost$ssl8, _fleetServerHost$ssl$9, _fleetServerHost$ssl9, _secrets3, _secrets3$ssl, _fleetServerHost$ssl$10, _fleetServerHost$ssl10;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    notifications,
    cloud
  } = (0, _hooks.useStartServices)();
  const authz = (0, _hooks.useAuthz)();
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();
  const isEditDisabled = (_ref = (fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.is_preconfigured) || !authz.fleet.allSettings) !== null && _ref !== void 0 ? _ref : false;
  const nameInput = (0, _hooks.useInput)((_fleetServerHost$name = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.name) !== null && _fleetServerHost$name !== void 0 ? _fleetServerHost$name : '', validateName, isEditDisabled);
  const isDefaultInput = (0, _hooks.useSwitchInput)((_fleetServerHost$is_d = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.is_default) !== null && _fleetServerHost$is_d !== void 0 ? _fleetServerHost$is_d : false, isEditDisabled || (fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.is_default));
  const isServerless = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled;
  // Set the host URLs to default for new Fleet server host in serverless.
  const hostUrlsDefaultValue = isServerless && !(fleetServerHost !== null && fleetServerHost !== void 0 && fleetServerHost.host_urls) ? (defaultFleetServerHost === null || defaultFleetServerHost === void 0 ? void 0 : defaultFleetServerHost.host_urls) || [] : (fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.host_urls) || [];
  const hostUrlsDisabled = isEditDisabled || isServerless;
  const hostUrlsInput = (0, _hooks.useComboInput)('hostUrls', hostUrlsDefaultValue, validateFleetServerHosts, hostUrlsDisabled);
  const proxyIdInput = (0, _hooks.useInput)((_fleetServerHost$prox = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : fleetServerHost.proxy_id) !== null && _fleetServerHost$prox !== void 0 ? _fleetServerHost$prox : '', () => undefined, isEditDisabled);
  const sslCertificateAuthoritiesInput = (0, _hooks.useComboInput)('sslCertificateAuthoritiesComboxBox', (_fleetServerHost$ssl$ = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl = fleetServerHost.ssl) === null || _fleetServerHost$ssl === void 0 ? void 0 : _fleetServerHost$ssl.certificate_authorities) !== null && _fleetServerHost$ssl$ !== void 0 ? _fleetServerHost$ssl$ : [], undefined, isEditDisabled);
  const sslCertificateInput = (0, _hooks.useInput)((_fleetServerHost$ssl$2 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl2 = fleetServerHost.ssl) === null || _fleetServerHost$ssl2 === void 0 ? void 0 : _fleetServerHost$ssl2.certificate) !== null && _fleetServerHost$ssl$2 !== void 0 ? _fleetServerHost$ssl$2 : '', () => undefined, isEditDisabled);
  const sslEsCertificateAuthoritiesInput = (0, _hooks.useComboInput)('sslEsCertificateAuthoritiesComboxBox', (_fleetServerHost$ssl$3 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl3 = fleetServerHost.ssl) === null || _fleetServerHost$ssl3 === void 0 ? void 0 : _fleetServerHost$ssl3.es_certificate_authorities) !== null && _fleetServerHost$ssl$3 !== void 0 ? _fleetServerHost$ssl$3 : [], undefined, isEditDisabled);
  const sslEsCertificateInput = (0, _hooks.useInput)((_fleetServerHost$ssl$4 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl4 = fleetServerHost.ssl) === null || _fleetServerHost$ssl4 === void 0 ? void 0 : _fleetServerHost$ssl4.es_certificate) !== null && _fleetServerHost$ssl$4 !== void 0 ? _fleetServerHost$ssl$4 : '', () => undefined, isEditDisabled);
  const sslKeyInput = (0, _hooks.useInput)((_fleetServerHost$ssl$5 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl5 = fleetServerHost.ssl) === null || _fleetServerHost$ssl5 === void 0 ? void 0 : _fleetServerHost$ssl5.key) !== null && _fleetServerHost$ssl$5 !== void 0 ? _fleetServerHost$ssl$5 : '', undefined, isEditDisabled);
  const sslESKeyInput = (0, _hooks.useInput)((_fleetServerHost$ssl$6 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl6 = fleetServerHost.ssl) === null || _fleetServerHost$ssl6 === void 0 ? void 0 : _fleetServerHost$ssl6.es_key) !== null && _fleetServerHost$ssl$6 !== void 0 ? _fleetServerHost$ssl$6 : '', undefined, isEditDisabled);
  const sslKeySecretInput = (0, _hooks.useSecretInput)(fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_secrets = fleetServerHost.secrets) === null || _secrets === void 0 ? void 0 : (_secrets$ssl = _secrets.ssl) === null || _secrets$ssl === void 0 ? void 0 : _secrets$ssl.key, undefined, isEditDisabled);
  const sslESKeySecretInput = (0, _hooks.useSecretInput)(fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_secrets2 = fleetServerHost.secrets) === null || _secrets2 === void 0 ? void 0 : (_secrets2$ssl = _secrets2.ssl) === null || _secrets2$ssl === void 0 ? void 0 : _secrets2$ssl.es_key, undefined, isEditDisabled);
  const sslClientAuthInput = (0, _hooks.useRadioInput)((_fleetServerHost$ssl$7 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl7 = fleetServerHost.ssl) === null || _fleetServerHost$ssl7 === void 0 ? void 0 : _fleetServerHost$ssl7.client_auth) !== null && _fleetServerHost$ssl$7 !== void 0 ? _fleetServerHost$ssl$7 : _types.clientAuth.None, isEditDisabled);
  const sslAgentCertificateAuthoritiesInput = (0, _hooks.useComboInput)('sslAgentCertificateAuthoritiesComboxBox', (_fleetServerHost$ssl$8 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl8 = fleetServerHost.ssl) === null || _fleetServerHost$ssl8 === void 0 ? void 0 : _fleetServerHost$ssl8.agent_certificate_authorities) !== null && _fleetServerHost$ssl$8 !== void 0 ? _fleetServerHost$ssl$8 : [], undefined, isEditDisabled);
  const sslAgentCertificateInput = (0, _hooks.useInput)((_fleetServerHost$ssl$9 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl9 = fleetServerHost.ssl) === null || _fleetServerHost$ssl9 === void 0 ? void 0 : _fleetServerHost$ssl9.agent_certificate) !== null && _fleetServerHost$ssl$9 !== void 0 ? _fleetServerHost$ssl$9 : '', () => undefined, isEditDisabled);
  const sslAgentKeySecretInput = (0, _hooks.useSecretInput)(fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_secrets3 = fleetServerHost.secrets) === null || _secrets3 === void 0 ? void 0 : (_secrets3$ssl = _secrets3.ssl) === null || _secrets3$ssl === void 0 ? void 0 : _secrets3$ssl.agent_key, undefined, isEditDisabled);
  const sslAgentKeyInput = (0, _hooks.useInput)((_fleetServerHost$ssl$10 = fleetServerHost === null || fleetServerHost === void 0 ? void 0 : (_fleetServerHost$ssl10 = fleetServerHost.ssl) === null || _fleetServerHost$ssl10 === void 0 ? void 0 : _fleetServerHost$ssl10.agent_key) !== null && _fleetServerHost$ssl$10 !== void 0 ? _fleetServerHost$ssl$10 : '', undefined, isEditDisabled);
  const inputs = (0, _react.useMemo)(() => ({
    nameInput,
    isDefaultInput,
    hostUrlsInput,
    proxyIdInput,
    sslCertificateAuthoritiesInput,
    sslCertificateInput,
    sslEsCertificateAuthoritiesInput,
    sslEsCertificateInput,
    sslKeyInput,
    sslESKeyInput,
    sslKeySecretInput,
    sslESKeySecretInput,
    sslClientAuthInput,
    sslAgentCertificateAuthoritiesInput,
    sslAgentCertificateInput,
    sslAgentKeyInput,
    sslAgentKeySecretInput
  }), [nameInput, isDefaultInput, hostUrlsInput, proxyIdInput, sslCertificateAuthoritiesInput, sslCertificateInput, sslEsCertificateAuthoritiesInput, sslEsCertificateInput, sslKeyInput, sslESKeyInput, sslKeySecretInput, sslESKeySecretInput, sslClientAuthInput, sslAgentCertificateAuthoritiesInput, sslAgentCertificateInput, sslAgentKeyInput, sslAgentKeySecretInput]);
  const validate = (0, _react.useCallback)(() => (0, _hooks.validateInputs)({
    ...inputs
  }), [inputs]);
  const submit = (0, _react.useCallback)(async () => {
    try {
      if (!validate()) {
        return;
      }
      if (!(await confirm(/*#__PURE__*/_react.default.createElement(ConfirmTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 27
        }
      }), /*#__PURE__*/_react.default.createElement(ConfirmDescription, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 45
        }
      })))) {
        return;
      }
      setIsLoading(true);
      const data = {
        name: nameInput.value,
        host_urls: hostUrlsInput.value,
        is_default: isDefaultInput.value,
        proxy_id: proxyIdInput.value !== '' ? proxyIdInput.value : null,
        ssl: {
          certificate: sslCertificateInput.value,
          key: sslKeyInput.value || undefined,
          certificate_authorities: sslCertificateAuthoritiesInput.value.filter(val => val !== ''),
          es_certificate: sslEsCertificateInput.value,
          es_key: sslESKeyInput.value || undefined,
          es_certificate_authorities: sslEsCertificateAuthoritiesInput.value.filter(val => val !== ''),
          agent_certificate: sslAgentCertificateInput.value,
          agent_key: sslAgentKeyInput.value || undefined,
          agent_certificate_authorities: sslAgentCertificateAuthoritiesInput.value.filter(val => val !== ''),
          ...(sslClientAuthInput.value !== _types.clientAuth.None && {
            client_auth: sslClientAuthInput.value
          })
        },
        ...((!sslKeyInput.value && sslKeySecretInput.value || !sslESKeyInput.value && sslESKeySecretInput.value || !sslAgentKeyInput.value && sslAgentKeySecretInput.value) && {
          secrets: {
            ssl: {
              key: sslKeySecretInput.value || undefined,
              es_key: sslESKeySecretInput.value || undefined,
              agent_key: sslAgentKeySecretInput.value || undefined
            }
          }
        })
      };
      if (fleetServerHost) {
        const res = await (0, _hooks.sendPutFleetServerHost)(fleetServerHost.id, data);
        if (res.error) {
          throw res.error;
        }
      } else {
        const res = await (0, _hooks.sendPostFleetServerHost)(data);
        if (res.error) {
          throw res.error;
        }
      }
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.successToastTitle', {
        defaultMessage: 'Fleet Server host saved'
      }));
      setIsLoading(false);
      await onSuccess();
    } catch (error) {
      setIsLoading(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.errorToastTitle', {
          defaultMessage: 'An error happened while saving Fleet Server host'
        })
      });
    }
  }, [validate, confirm, nameInput.value, hostUrlsInput.value, isDefaultInput.value, proxyIdInput.value, sslCertificateInput.value, sslKeyInput.value, sslCertificateAuthoritiesInput.value, sslEsCertificateInput.value, sslESKeyInput.value, sslEsCertificateAuthoritiesInput.value, sslClientAuthInput.value, sslKeySecretInput.value, sslESKeySecretInput.value, fleetServerHost, notifications.toasts, sslAgentKeyInput.value, sslAgentKeySecretInput.value, sslAgentCertificateInput.value, sslAgentCertificateAuthoritiesInput.value, onSuccess]);
  const hasChanged = Object.values(inputs).some(input => input.hasChanged);
  const isDisabled = isEditDisabled || isLoading || !hasChanged || hostUrlsInput.props.isInvalid || nameInput.props.isInvalid;
  return {
    isLoading,
    isDisabled,
    submit,
    inputs
  };
}