"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewErrors = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _build_query = require("../../agent_details_page/components/agent_logs/build_query");
var _view_logs_button = require("../../agent_details_page/components/agent_logs/view_logs_button");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/view_errors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TruncatedEuiText = (0, _styledComponents.default)(_eui.EuiText)`
  overflow: hidden;
  max-height: 3rem;
  text-overflow: ellipsis;
`;
const ViewErrors = ({
  action
}) => {
  var _action$latestErrors2;
  const coreStart = (0, _hooks.useStartServices)();
  const theme = (0, _eui.useEuiTheme)();
  const getLogsButton = (agentId, timestamp) => {
    const start = (0, _moment.default)(timestamp).subtract(5, 'm').toISOString();
    const end = (0, _moment.default)(timestamp).add(5, 'm').toISOString();
    const startTime = (0, _view_logs_button.getFormattedRange)(start);
    const endTime = (0, _view_logs_button.getFormattedRange)(end);
    const logStreamQuery = (0, _build_query.buildQuery)({
      agentId,
      datasets: ['elastic_agent'],
      logLevels: ['error'],
      userQuery: ''
    });
    return /*#__PURE__*/_react.default.createElement(_view_logs_button.ViewLogsButton, {
      logStreamQuery: logStreamQuery,
      startTime: startTime,
      endTime: endTime,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    });
  };
  const columns = [{
    field: 'hostname',
    name: _i18n.i18n.translate('xpack.fleet.agentList.viewErrors.hostnameColumnTitle', {
      defaultMessage: 'Host Name'
    }),
    render: hostname => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "hostText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, hostname)
  }, {
    field: 'error',
    name: _i18n.i18n.translate('xpack.fleet.agentList.viewErrors.errorColumnTitle', {
      defaultMessage: 'Error Message'
    }),
    render: error => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(TruncatedEuiText, {
      size: "s",
      color: theme.euiTheme.colors.textDanger,
      "data-test-subj": "errorText",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, error))
  }, {
    field: 'agentId',
    name: _i18n.i18n.translate('xpack.fleet.agentList.viewErrors.actionColumnTitle', {
      defaultMessage: 'Action'
    }),
    render: agentId => {
      var _action$latestErrors;
      const errorItem = ((_action$latestErrors = action.latestErrors) !== null && _action$latestErrors !== void 0 ? _action$latestErrors : []).find(item => item.agentId === agentId);
      return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
        coreStart: coreStart,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 11
        }
      }, getLogsButton(agentId, errorItem.timestamp));
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: action.actionId + '_errors',
    buttonContent: "Show errors",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: (_action$latestErrors2 = action.latestErrors) !== null && _action$latestErrors2 !== void 0 ? _action$latestErrors2 : [],
    columns: columns,
    tableLayout: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  })));
};
exports.ViewErrors = ViewErrors;