"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAgentMigrationSupported = exports.isAgentEligibleForMigration = exports.MINIMUM_MIGRATE_AGENT_VERSION = void 0;
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _agent_policies_helpers = require("./agent_policies_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MINIMUM_MIGRATE_AGENT_VERSION = exports.MINIMUM_MIGRATE_AGENT_VERSION = '9.2.0';
const isAgentMigrationSupported = agent => {
  var _agent$agent, _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3;
  // Check if agent meets minimum version requirement
  const meetsVersionRequirement = !((_agent$agent = agent.agent) !== null && _agent$agent !== void 0 && _agent$agent.version) || (0, _gte.default)(agent.agent.version, MINIMUM_MIGRATE_AGENT_VERSION);

  // Check if agent is not containerized (containerized agents have upgradeable: false)
  const isNotContainerized = ((_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.upgradeable) !== false;
  return meetsVersionRequirement && isNotContainerized;
};
exports.isAgentMigrationSupported = isAgentMigrationSupported;
const isAgentEligibleForMigration = (agent, agentPolicy) => {
  const hasFleetServer = agentPolicy && (0, _agent_policies_helpers.policyHasFleetServer)(agentPolicy);
  return isAgentMigrationSupported(agent) && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_protected) && !hasFleetServer;
};
exports.isAgentEligibleForMigration = isAgentEligibleForMigration;