"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlFiltersToKueryString = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Extract a map's keys to an array, then map those keys to a string per key.
 * The strings contain all of the values chosen for the given field (which is also the key value).
 * Reduce the list of query strings to a singular string, with AND operators between.
 */

const buildOrCondition = values => {
  if (values.length === 1) {
    return `${values.join(' or ')}`;
  }
  return `(${values.join(' or ')})`;
};
function addSlashes(str) {
  return (str + '').replace(/[\\"']/g, '\\$&').replace(/\u0000/g, '\\0');
}
const urlFiltersToKueryString = urlFilters => {
  let kueryString = '';
  urlFilters.forEach(({
    field,
    values,
    notValues,
    wildcards,
    notWildcards
  }) => {
    const valuesT = values === null || values === void 0 ? void 0 : values.map(val => `"${addSlashes(val)}"`);
    const notValuesT = notValues === null || notValues === void 0 ? void 0 : notValues.map(val => `"${addSlashes(val)}"`);
    const wildcardsT = wildcards === null || wildcards === void 0 ? void 0 : wildcards.map(val => `*${val}*`);
    const notWildcardsT = notWildcards === null || notWildcards === void 0 ? void 0 : notWildcards.map(val => `*${val}*`);
    if (valuesT && (valuesT === null || valuesT === void 0 ? void 0 : valuesT.length) > 0) {
      if (kueryString.length > 0) {
        kueryString += ' and ';
      }
      kueryString += `${field}: ${buildOrCondition(valuesT)}`;
    }
    if (notValuesT && (notValuesT === null || notValuesT === void 0 ? void 0 : notValuesT.length) > 0) {
      if (kueryString.length > 0) {
        kueryString += ' and ';
      }
      kueryString += `not (${field}: ${buildOrCondition(notValuesT)})`;
    }
    if (wildcardsT && (wildcardsT === null || wildcardsT === void 0 ? void 0 : wildcardsT.length) > 0) {
      if (kueryString.length > 0) {
        kueryString += ' and ';
      }
      kueryString += `(${field}: ${buildOrCondition(wildcardsT)})`;
    }
    if (notWildcardsT && (notWildcardsT === null || notWildcardsT === void 0 ? void 0 : notWildcardsT.length) > 0) {
      if (kueryString.length > 0) {
        kueryString += ' and ';
      }
      kueryString += `(${field}: ${buildOrCondition(notWildcardsT)})`;
    }
  });
  return kueryString;
};
exports.urlFiltersToKueryString = urlFiltersToKueryString;