"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endsWithInOrNotInToken = endsWithInOrNotInToken;
exports.endsWithIsOrIsNotToken = endsWithIsOrIsNotToken;
exports.endsWithLikeOrRlikeToken = endsWithLikeOrRlikeToken;
exports.getLogicalContinuationSuggestions = getLogicalContinuationSuggestions;
exports.shouldSuggestOpenListForOperand = shouldSuggestOpenListForOperand;
var _is = require("../../../../../ast/is");
var _ast = require("../../../ast");
var _operators = require("../../../operators");
var _all_operators = require("../../../../all_operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** Returns true if we should suggest opening a list for the right operand */
function shouldSuggestOpenListForOperand(operand) {
  return !operand || (0, _ast.isMarkerNode)(operand) || (operand === null || operand === void 0 ? void 0 : operand.type) === 'unknown' && (operand === null || operand === void 0 ? void 0 : operand.incomplete) === true || (0, _is.isList)(operand) && operand.location.min === 0 && operand.location.max === 0;
}

/** Suggestions for logical continuations after a complete list or null-check operator */
function getLogicalContinuationSuggestions() {
  return _all_operators.logicalOperators.map(_operators.getOperatorSuggestion);
}
function endsWithInOrNotInToken(innerText) {
  return /\b(?:not\s+)?in\s*\(?\s*$/i.test(innerText);
}
function endsWithLikeOrRlikeToken(innerText) {
  return /\b(?:not\s+)?r?like\s+$/i.test(innerText);
}
function endsWithIsOrIsNotToken(innerText) {
  return /\bis\s+(?:n(?:o(?:t(?:\s+n(?:u(?:l(?:l)?)?)?|\s*)?)?|u(?:l(?:l)?)?)?)?$/i.test(innerText);
}