"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.patternMatchOperators = exports.operatorsDefinitions = exports.nullCheckOperators = exports.logicalOperators = exports.inOperators = exports.comparisonFunctions = exports.arithmeticOperators = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../commands_registry/types");
var _types2 = require("./types");
var _operators = require("./generated/operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Retrieve the definitions from the operatorFunctionDefinitions. In the operatorFunctionDefinitions there is no distinction between
// other operators and the comparison ones, so we do this here.
const arithmeticOperators = exports.arithmeticOperators = _operators.operatorFunctionDefinitions.filter(({
  name
}) => name === '+' || name === '-' || name === '*' || name === '/' || name === '%');
const comparisonFunctions = exports.comparisonFunctions = _operators.operatorFunctionDefinitions.filter(({
  name
}) => name === '==' || name === '!=' || name === '<' || name === '>' || name === '<=' || name === '>=');
const nullCheckOperators = exports.nullCheckOperators = _operators.operatorFunctionDefinitions.filter(({
  name
}) => name === 'is null' || name === 'is not null');
const inOperators = exports.inOperators = _operators.operatorFunctionDefinitions.filter(({
  name
}) => name === 'in' || name === 'not in');
const patternMatchOperators = exports.patternMatchOperators = _operators.operatorFunctionDefinitions.filter(({
  name
}) => name === 'like' || name === 'not like' || name === 'rlike' || name === 'not rlike');
const logicalOperators = exports.logicalOperators = [{
  name: 'and',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definition.andDoc', {
    defaultMessage: 'and'
  })
}, {
  name: 'or',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definition.orDoc', {
    defaultMessage: 'or'
  })
}].map(({
  name,
  description
}) => ({
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name,
  description,
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS, _types.Location.STATS_BY, _types.Location.STATS_WHERE, _types.Location.RERANK],
  signatures: [{
    params: [{
      name: 'left',
      type: 'boolean'
    }, {
      name: 'right',
      type: 'boolean'
    }],
    returnType: 'boolean'
  }]
}));
const otherDefinitions = [{
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'not',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definition.notDoc', {
    defaultMessage: 'Not'
  }),
  locationsAvailable: [_types.Location.EVAL, _types.Location.WHERE, _types.Location.ROW, _types.Location.SORT, _types.Location.STATS_BY, _types.Location.STATS_WHERE, _types.Location.RERANK],
  signatures: [{
    params: [{
      name: 'expression',
      type: 'boolean'
    }],
    returnType: 'boolean'
  }]
}, {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: '=',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definition.assignDoc', {
    defaultMessage: 'Assign (=)'
  }),
  locationsAvailable: [_types.Location.EVAL, _types.Location.STATS, _types.Location.STATS_BY, _types.Location.ROW, _types.Location.WHERE, _types.Location.ENRICH, _types.Location.ENRICH_WITH, _types.Location.DISSECT, _types.Location.COMPLETION, _types.Location.RENAME, _types.Location.RERANK],
  signatures: [{
    params: [{
      name: 'left',
      type: 'any'
    }, {
      name: 'right',
      type: 'any'
    }],
    returnType: 'unknown'
  }]
}, {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'as',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definition.asDoc', {
    defaultMessage: 'Rename as (AS)'
  }),
  locationsAvailable: [_types.Location.RENAME, _types.Location.JOIN],
  signatures: [{
    params: [{
      name: 'oldName',
      type: 'any'
    }, {
      name: 'newName',
      type: 'any'
    }],
    returnType: 'unknown'
  }]
}, {
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  name: 'where',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definition.whereDoc', {
    defaultMessage: 'WHERE operator'
  }),
  locationsAvailable: [_types.Location.STATS],
  ignoreAsSuggestion: true,
  signatures: [{
    params: [{
      name: 'left',
      type: 'any'
    }, {
      name: 'right',
      type: 'any'
    }],
    returnType: 'unknown'
  }]
}, {
  // TODO — this shouldn't be a function or an operator...
  name: 'info',
  type: _types2.FunctionDefinitionTypes.OPERATOR,
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definition.infoDoc', {
    defaultMessage: 'Show information about the current ES node'
  }),
  locationsAvailable: [_types.Location.SHOW],
  signatures: [{
    params: [],
    returnType: 'unknown' // meaningless
  }]
}];
const operatorsDefinitions = exports.operatorsDefinitions = [..._operators.operatorFunctionDefinitions, ...logicalOperators, ...otherDefinitions];