"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityDefinition = exports.backfillInstalledComponents = exports.SO_ENTITY_DEFINITION_TYPE = void 0;
var _generate_component_id = require("../lib/entities/helpers/generate_component_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SO_ENTITY_DEFINITION_TYPE = exports.SO_ENTITY_DEFINITION_TYPE = 'entity-definition';
const backfillInstalledComponents = savedObject => {
  const definition = savedObject.attributes;
  definition.installedComponents = [{
    type: 'transform',
    id: (0, _generate_component_id.generateHistoryTransformId)(definition)
  }, {
    type: 'transform',
    id: (0, _generate_component_id.generateLatestTransformId)(definition)
  }, {
    type: 'ingest_pipeline',
    id: (0, _generate_component_id.generateHistoryIngestPipelineId)(definition)
  }, {
    type: 'ingest_pipeline',
    id: (0, _generate_component_id.generateLatestIngestPipelineId)(definition)
  }, {
    type: 'template',
    id: (0, _generate_component_id.generateHistoryIndexTemplateId)(definition)
  }, {
    type: 'template',
    id: (0, _generate_component_id.generateLatestIndexTemplateId)(definition)
  }];
  return savedObject;
};
exports.backfillInstalledComponents = backfillInstalledComponents;
const removeOptionalIdentityFields = savedObject => {
  // Doing only this may break displayNameTemplates
  savedObject.attributes.identityFields = savedObject.attributes.identityFields.filter(identityField => identityField.optional === false);
  return {
    document: savedObject
  };
};
const entityDefinition = exports.entityDefinition = {
  name: SO_ENTITY_DEFINITION_TYPE,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {
      id: {
        type: 'keyword'
      },
      version: {
        type: 'keyword'
      },
      name: {
        type: 'text'
      },
      description: {
        type: 'text'
      },
      type: {
        type: 'keyword'
      },
      filter: {
        type: 'keyword'
      },
      indexPatterns: {
        type: 'keyword'
      },
      identityFields: {
        type: 'object'
      },
      metadata: {
        type: 'object'
      },
      metrics: {
        type: 'object'
      },
      staticFields: {
        type: 'object'
      },
      managed: {
        type: 'boolean'
      }
    }
  },
  management: {
    displayName: 'Entity Definition',
    importableAndExportable: false,
    getTitle(savedObject) {
      return `EntityDefinition: [${savedObject.attributes.name}]`;
    }
  },
  modelVersions: {
    '1': {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          version: {
            type: 'keyword'
          }
        }
      }]
    },
    '2': {
      changes: [{
        type: 'data_backfill',
        backfillFn: () => {
          return {
            attributes: {
              installStatus: 'installed',
              installStartedAt: new Date().toISOString()
            }
          };
        }
      }]
    },
    '3': {
      changes: [{
        type: 'data_backfill',
        backfillFn: backfillInstalledComponents
      }]
    },
    '4': {
      changes: [{
        type: 'unsafe_transform',
        transformFn: typeSafeGuard => typeSafeGuard(removeOptionalIdentityFields)
      }]
    }
  }
};