"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerStatsRoutes = registerStatsRoutes;
var _configSchema = require("@kbn/config-schema");
var _get_sync_jobs = require("../../lib/stats/get_sync_jobs");
var _elasticsearch_error_handler = require("../../utils/elasticsearch_error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerStatsRoutes({
  log,
  router
}) {
  router.get({
    path: '/internal/enterprise_search/stats/sync_jobs',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: {
      query: _configSchema.schema.object({
        isCrawler: _configSchema.schema.maybe(_configSchema.schema.boolean())
      })
    }
  }, (0, _elasticsearch_error_handler.elasticsearchErrorHandler)(log, async (context, request, response) => {
    const {
      client
    } = (await context.core).elasticsearch;
    const {
      isCrawler
    } = request.query;
    const body = await (0, _get_sync_jobs.fetchSyncJobsStats)(client, isCrawler);
    return response.ok({
      body
    });
  }));
}