"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchTitle = exports.searchApplicationsTitle = exports.generateTitle = exports.enterpriseSearchContentTitle = exports.elasticsearchTitle = exports.analyticsTitle = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generate a document title that generally follows our breadcrumb trails
 * https://github.com/elastic/kibana/blob/8.0/docs/development/core/public/kibana-plugin-core-public.chromedoctitle.md
 */

/**
 * Given an array of page titles, return a final formatted document title
 * @param pages - e.g., ['Curations', 'some Engine', 'App Search']
 * @returns - e.g., 'Curations - some Engine - App Search'
 */
const generateTitle = pages => pages.join(' - ');

/**
 * Product-specific helpers
 */
exports.generateTitle = generateTitle;
const searchTitle = (page = []) => generateTitle([...page, _constants.SEARCH_PRODUCT_NAME]);
exports.searchTitle = searchTitle;
const analyticsTitle = (page = []) => generateTitle([...page, _constants.ANALYTICS_PLUGIN.NAME]);
exports.analyticsTitle = analyticsTitle;
const elasticsearchTitle = (page = []) => generateTitle([...page, _i18n.i18n.translate('xpack.enterpriseSearch.titles.elasticsearch', {
  defaultMessage: 'Getting started with Elasticsearch'
})]);
exports.elasticsearchTitle = elasticsearchTitle;
const enterpriseSearchContentTitle = (page = []) => generateTitle([...page, _constants.ENTERPRISE_SEARCH_DATA_PLUGIN.NAME]);
exports.enterpriseSearchContentTitle = enterpriseSearchContentTitle;
const searchApplicationsTitle = (page = []) => generateTitle([...page, _constants.SEARCH_APPS_TITLE]);
exports.searchApplicationsTitle = searchApplicationsTitle;