"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMetaTotalState = exports.updateMetaPageIndex = exports.DEFAULT_META = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_META = exports.DEFAULT_META = {
  from: 0,
  size: 10,
  total: 0
};
const updateMetaTotalState = (oldState, newTotal) => {
  return {
    ...oldState,
    total: newTotal
  };
};
exports.updateMetaTotalState = updateMetaTotalState;
const updateMetaPageIndex = (oldState, newPageIndex) => {
  return {
    ...oldState,
    from: newPageIndex * oldState.size
  };
};
exports.updateMetaPageIndex = updateMetaPageIndex;